/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.translator;

import com.google.code.twig.Path;
import com.google.code.twig.Property;
import com.google.code.twig.PropertyTranslator;
import com.google.code.twig.conversion.CombinedConverter;
import com.google.code.twig.conversion.SpecificConverter;
import com.google.code.twig.util.PropertySets;
import java.lang.reflect.Type;
import java.util.Set;

public class ConvertableTypeTranslator
implements PropertyTranslator {
    private final CombinedConverter converter;

    public ConvertableTypeTranslator(CombinedConverter converter) {
        this.converter = converter;
    }

    @Override
    public Object decode(Set<Property> properties, Path path, Type type) {
        if (properties.size() == 1) {
            Object value = PropertySets.firstValue(properties);
            if (value instanceof String || value instanceof Long) {
                return this.typesafeConvert(type, value);
            }
            if (value == null) {
                return NULL_VALUE;
            }
        } else if (properties.isEmpty()) {
            return NULL_VALUE;
        }
        return null;
    }

    private <S, T> T typesafeConvert(Type type, S value) {
        SpecificConverter<?, ?> specific = this.converter.converter(value.getClass(), type);
        if (specific != null) {
            return (T)specific.convert(value);
        }
        return null;
    }

    @Override
    public Set<Property> encode(Object instance, Path path, boolean indexed) {
        Object value = this.typesafeConvert((Type)((Object)String.class), (Object)instance);
        if (value == null) {
            value = this.typesafeConvert((Type)((Object)Long.class), (Object)instance);
        }
        if (value != null) {
            return PropertySets.singletonPropertySet(path, value, indexed);
        }
        return null;
    }
}

