/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.translator;

import com.google.code.twig.Path;
import com.google.code.twig.Property;
import com.google.code.twig.PropertyTranslator;
import com.google.code.twig.util.SimpleProperty;
import com.google.code.twig.util.generic.GenericTypeReflector;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;

public class EnumTranslator
implements PropertyTranslator {
    @Override
    public Object decode(Set<Property> properties, Path path, Type type) {
        Class<?> clazz = GenericTypeReflector.erase(type);
        if (clazz.isEnum()) {
            Property property = properties.iterator().next();
            String name = (String)property.getValue();
            Class<?> ce = clazz;
            return Enum.valueOf(ce, name);
        }
        return null;
    }

    @Override
    public Set<Property> encode(Object object, Path path, boolean indexed) {
        if (object instanceof Enum) {
            String name = ((Enum)object).name();
            SimpleProperty property = new SimpleProperty(path, name, indexed);
            return Collections.singleton(property);
        }
        return null;
    }
}

