/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.util;

import com.google.code.twig.Path;
import com.google.code.twig.Property;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterators;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Set;

public class PrefixFilteringPropertySet
extends AbstractSet<Property> {
    private final Set<Property> properties;
    private final Path prefix;

    public PrefixFilteringPropertySet(Path prefix, Set<Property> properties) {
        this.prefix = prefix;
        this.properties = properties;
    }

    @Override
    public Iterator<Property> iterator() {
        return Iterators.filter(this.properties.iterator(), (Predicate)new Predicate<Property>(){

            public boolean apply(Property source) {
                Path path = source.getPath();
                return path.equals(PrefixFilteringPropertySet.this.prefix) || path.hasPrefix(PrefixFilteringPropertySet.this.prefix);
            }
        });
    }

    @Override
    public int size() {
        return Iterators.size(this.iterator());
    }

    @Override
    public boolean isEmpty() {
        return !this.iterator().hasNext();
    }
}

