/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.util;

import com.google.code.twig.Path;
import com.google.code.twig.Property;
import com.google.code.twig.util.PrefixPropertySet;
import com.google.code.twig.util.PropertyComparator;
import com.google.code.twig.util.PropertyMapToSet;
import com.google.code.twig.util.SinglePropertySet;
import com.vercer.util.collections.ArraySortedSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class PropertySets {
    private static final PropertyComparator comparator = new PropertyComparator();

    public static <T> T firstValue(Set<Property> properties) {
        return (T)PropertySets.firstProperty(properties).getValue();
    }

    public static <T> T uniqueValue(Set<Property> properties) {
        if (properties.size() != 1) {
            throw new IllegalStateException("Expected one property but was " + properties.size());
        }
        T firstValue = PropertySets.firstValue(properties);
        return firstValue;
    }

    public static Collection<PrefixPropertySet> prefixPropertySets(Set<Property> properties, Path prefix) {
        Property[] array = properties.toArray(new Property[properties.size()]);
        ArrayList<PrefixPropertySet> result = new ArrayList<PrefixPropertySet>();
        Path.Part part = null;
        int start = 0;
        for (int i = 0; i < array.length; ++i) {
            Path.Part firstPartAfterPrefix = array[i].getPath().firstPartAfterPrefix(prefix);
            if (part != null && !firstPartAfterPrefix.equals(part)) {
                PrefixPropertySet ppf = PropertySets.createPrefixSubset(prefix, array, part, start, i);
                result.add(ppf);
                start = i;
            }
            part = firstPartAfterPrefix;
        }
        if (array.length > 0) {
            PrefixPropertySet ppf = PropertySets.createPrefixSubset(prefix, array, part, start, array.length);
            result.add(ppf);
        }
        return result;
    }

    private static PrefixPropertySet createPrefixSubset(Path prefix, Property[] array, Path.Part part, int start, int i) {
        ArraySortedSet<Property> subset = new ArraySortedSet<Property>(array, start, i - start, comparator);
        PrefixPropertySet ppf = new PrefixPropertySet(Path.builder(prefix).append(part).build(), subset);
        return ppf;
    }

    public static Set<Property> create(Map<String, Object> properties, boolean indexed) {
        return new PropertyMapToSet(properties, indexed);
    }

    public static <T> T valueForPath(String path, Set<Property> properties) {
        for (Property property : properties) {
            if (!property.getPath().toString().equals(path)) continue;
            return (T)property.getValue();
        }
        return null;
    }

    public static Set<Property> singletonPropertySet(Path path, Object value, boolean indexed) {
        return new SinglePropertySet(path, value, indexed);
    }

    public static Property firstProperty(Set<Property> properties) {
        if (properties instanceof SinglePropertySet) {
            return (SinglePropertySet)properties;
        }
        Iterator<Property> iterator = properties.iterator();
        if (iterator.hasNext()) {
            return iterator.next();
        }
        return null;
    }
}

