/*
 * Decompiled with CFR 0.152.
 */
package com.vercer.util;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;

public abstract class LazyProxy<T> {
    private final Class<?> interfaceClass;

    public LazyProxy(Class<?> interfaceClass) {
        this.interfaceClass = interfaceClass;
    }

    public T newProxy() {
        LaxyInvocationHandler handler = new LaxyInvocationHandler(this);
        return (T)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.interfaceClass}, handler);
    }

    protected abstract T newInstance();

    public static <T> T getInstance(T proxy) {
        LaxyInvocationHandler handler = (LaxyInvocationHandler)Proxy.getInvocationHandler(proxy);
        return (T)handler.instance;
    }

    private static final class LaxyInvocationHandler<T>
    implements InvocationHandler {
        private T instance;
        private final LazyProxy<T> lazyProxy;

        public LaxyInvocationHandler(LazyProxy<T> lazyProxy) {
            this.lazyProxy = lazyProxy;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            if (this.instance == null) {
                this.instance = this.lazyProxy.newInstance();
            }
            return method.invoke(this.instance, args);
        }
    }
}

