/*
 * Decompiled with CFR 0.152.
 */
package com.vercer.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;

public final class Strings {
    private static final Collection<String> noCaps = new ArrayList<String>();

    private Strings() {
    }

    public static int firstIndexOf(String source, char ... chars) {
        return Strings.firstIndexOf(source, 0, chars);
    }

    public static int firstIndexOf(String source, int start, char ... chars) {
        for (int i = start; i < source.length(); ++i) {
            char c = source.charAt(i);
            for (char d : chars) {
                if (c != d) continue;
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOf(String source, int start, char ... chars) {
        for (int i = start; i >= 0; --i) {
            char c = source.charAt(i);
            for (char d : chars) {
                if (c != d) continue;
                return i;
            }
        }
        return -1;
    }

    public static int nthIndexOf(String source, int n, char ... chars) {
        int index = -1;
        for (int i = 0; i < n; ++i) {
            index = Strings.firstIndexOf(source, index + 1, chars);
        }
        return index;
    }

    public static String[] split(String source, boolean include, char ... chars) {
        ArrayList<String> result = new ArrayList<String>();
        int start = 0;
        while (start < source.length() && start >= 0) {
            int next = Strings.firstIndexOf(source, start, chars);
            if (next <= 0) {
                result.add(source.substring(start));
                break;
            }
            result.add(source.substring(start, include ? next + 1 : next));
            start = next + 1;
        }
        return result.toArray(new String[result.size()]);
    }

    public static String onlyCharacterTypes(String source, int ... types) {
        StringBuilder builder = new StringBuilder(source.length());
        block0: for (int i = 0; i < source.length(); ++i) {
            char c = source.charAt(i);
            for (int j = 0; j < types.length; ++j) {
                if (Character.getType(c) != types[j]) continue;
                builder.append(c);
                continue block0;
            }
        }
        return builder.toString();
    }

    public static String toTitleCase(String title) {
        StringBuilder builder = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(title, " ", true);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            if (builder.length() == 0 || !tokenizer.hasMoreTokens() || !noCaps.contains(token)) {
                builder.append(Character.toUpperCase(token.charAt(0)));
                if (token.length() <= 1) continue;
                builder.append(token.substring(1));
                continue;
            }
            builder.append(token);
        }
        return builder.toString();
    }

    static {
        noCaps.add("to");
        noCaps.add("a");
        noCaps.add("an");
        noCaps.add("on");
        noCaps.add("to");
        noCaps.add("be");
        noCaps.add("am");
        noCaps.add("are");
        noCaps.add("were");
        noCaps.add("in");
        noCaps.add("near");
        noCaps.add("the");
        noCaps.add("with");
        noCaps.add("and");
        noCaps.add("or");
    }
}

