/*
 * Decompiled with CFR 0.152.
 */
package com.vercer.util.collections;

import com.google.common.collect.Iterators;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class MergeSet<T>
extends AbstractSet<T> {
    private int size;
    private final List<Collection<? extends T>> sets;

    public MergeSet() {
        this.sets = new ArrayList<Collection<? extends T>>();
    }

    public MergeSet(int size) {
        this.sets = new ArrayList<Collection<? extends T>>(size);
    }

    @Override
    public Iterator<T> iterator() {
        Iterator iterators = new Iterator<Iterator<? extends T>>(){
            Iterator<Collection<? extends T>> iterator;
            {
                this.iterator = MergeSet.this.sets.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            @Override
            public Iterator<? extends T> next() {
                return this.iterator.next().iterator();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
        return Iterators.concat((Iterator)iterators);
    }

    @Override
    public boolean addAll(Collection<? extends T> set) {
        if (set.isEmpty()) {
            return true;
        }
        this.size += set.size();
        return this.sets.add(set);
    }

    @Override
    public boolean add(T o) {
        return this.sets.add(Collections.singleton(o));
    }

    @Override
    public int size() {
        return this.size;
    }
}

