/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.DatastoreApiHelper;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.DatastoreServiceImpl;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityTranslator;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyTranslator;
import com.google.appengine.api.datastore.PreparedMultiQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.ReadPolicy;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.api.DatastorePb;
import com.google.code.twig.util.FutureAdaptor;
import com.google.code.twig.util.ImmediateFuture;
import com.google.storage.onestore.v3.OnestoreEntity;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;

public class AsyncDatastoreHelper {
    private static boolean runAllSync;

    public static Future<List<Key>> put(final Transaction txn, final Iterable<Entity> entities) {
        DatastorePb.PutRequest request = new DatastorePb.PutRequest();
        if (txn != null) {
            TransactionImpl.ensureTxnActive((Transaction)txn);
            request.setTransaction(DatastoreServiceImpl.localTxnToRemoteTxn((Transaction)txn));
        }
        for (Entity entity : entities) {
            OnestoreEntity.EntityProto proto = EntityTranslator.convertToPb((Entity)entity);
            request.addEntity(proto);
        }
        Future<byte[]> futureBytes = AsyncDatastoreHelper.makeAsyncCall("Put", request);
        return new FutureAdaptor<byte[], List<Key>>(futureBytes){

            @Override
            protected List<Key> adapt(byte[] bytes) {
                try {
                    DatastorePb.PutResponse response = new DatastorePb.PutResponse();
                    if (bytes != null) {
                        response.mergeFrom(bytes);
                    }
                    Iterator entitiesIterator = entities.iterator();
                    Iterator keyReferenceIterator = response.keys().iterator();
                    ArrayList<Key> keysInOrder = new ArrayList<Key>(response.keySize());
                    while (entitiesIterator.hasNext()) {
                        Entity entity = (Entity)entitiesIterator.next();
                        OnestoreEntity.Reference reference = (OnestoreEntity.Reference)keyReferenceIterator.next();
                        KeyTranslator.updateKey((OnestoreEntity.Reference)reference, (Key)entity.getKey());
                        keysInOrder.add(entity.getKey());
                    }
                    return keysInOrder;
                }
                catch (NoSuchMethodError e) {
                    DatastoreService service = DatastoreServiceFactory.getDatastoreService();
                    List result = service.put(txn, entities);
                    return result;
                }
            }
        };
    }

    public static Future<Map<Key, Entity>> get(Transaction txn, Iterable<Key> keys, ReadPolicy.Consistency consistency) {
        return AsyncDatastoreHelper.asyncGet(txn, keys, consistency);
    }

    private static Future<Map<Key, Entity>> asyncGet(final Transaction txn, final Iterable<Key> keys, ReadPolicy.Consistency consistency) {
        DatastorePb.GetRequest request = new DatastorePb.GetRequest();
        if (txn != null) {
            TransactionImpl.ensureTxnActive((Transaction)txn);
            request.setTransaction(DatastoreServiceImpl.localTxnToRemoteTxn((Transaction)txn));
        }
        for (Key key : keys) {
            request.addKey(KeyTranslator.convertToPb((Key)key));
        }
        if (consistency == ReadPolicy.Consistency.EVENTUAL) {
            request.setFailoverMs(-1L);
        }
        Future<byte[]> futureBytes = AsyncDatastoreHelper.makeAsyncCall("Get", request);
        return new FutureAdaptor<byte[], Map<Key, Entity>>(futureBytes){

            @Override
            protected Map<Key, Entity> adapt(byte[] bytes) {
                try {
                    HashMap<Key, Entity> result = new HashMap<Key, Entity>();
                    DatastorePb.GetResponse response = new DatastorePb.GetResponse();
                    if (bytes != null) {
                        response.mergeFrom(bytes);
                    }
                    Iterator keyIterator = keys.iterator();
                    Iterator entityReferenceIterator = response.entitys().iterator();
                    while (keyIterator.hasNext()) {
                        Key key = (Key)keyIterator.next();
                        DatastorePb.GetResponse.Entity entityReference = (DatastorePb.GetResponse.Entity)entityReferenceIterator.next();
                        if (!entityReference.hasEntity()) continue;
                        result.put(key, EntityTranslator.createFromPb((OnestoreEntity.EntityProto)entityReference.getEntity()));
                    }
                    return result;
                }
                catch (NoSuchMethodError e) {
                    DatastoreService service = DatastoreServiceFactory.getDatastoreService();
                    Map result = service.get(txn, keys);
                    return result;
                }
            }
        };
    }

    static Future<byte[]> makeAsyncCall(String method, ProtocolMessage<?> request) {
        try {
            if (!runAllSync) {
                return ApiProxy.makeAsyncCall((String)"datastore_v3", (String)method, (byte[])request.toByteArray());
            }
            return new ImmediateFuture<byte[]>(ApiProxy.makeSyncCall((String)"datastore_v3", (String)method, (byte[])request.toByteArray()));
        }
        catch (ApiProxy.ApplicationException exception) {
            throw DatastoreApiHelper.translateError((ApiProxy.ApplicationException)exception);
        }
    }

    public static Comparator<Entity> newEntityComparator(List<Query.SortPredicate> sorts) {
        return new PreparedMultiQuery.EntityComparator(sorts);
    }

    public static void setAlwaysUseSync(boolean runAllSync) {
        AsyncDatastoreHelper.runAllSync = runAllSync;
    }
}

