/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.api.datastore;

import com.google.appengine.api.datastore.AsyncDatastoreHelper;
import com.google.appengine.api.datastore.BasePreparedQuery;
import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.DatastoreServiceImpl;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QueryResultIterator;
import com.google.appengine.api.datastore.QueryResultIteratorImpl;
import com.google.appengine.api.datastore.QueryResultList;
import com.google.appengine.api.datastore.QueryResultsSource;
import com.google.appengine.api.datastore.QueryResultsSourceImpl;
import com.google.appengine.api.datastore.QueryTranslator;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.datastore.TransactionImpl;
import com.google.apphosting.api.ApiBasePb;
import com.google.apphosting.api.DatastorePb;
import com.google.code.twig.util.FutureAdaptor;
import com.google.code.twig.util.ImmediateFuture;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Future;

public class AsyncPreparedQuery
extends BasePreparedQuery {
    private final Query query;
    private final Transaction txn;

    public AsyncPreparedQuery(Query query, Transaction txn) {
        this.query = query;
        this.txn = txn;
    }

    public Future<QueryResultIterator<Entity>> asFutureQueryResultIterator() {
        return this.asFutureQueryResultIterator(FetchOptions.Builder.withDefaults());
    }

    public Future<QueryResultIterator<Entity>> asFutureQueryResultIterator(FetchOptions fetchOptions) {
        if (fetchOptions.getCompile() == null) {
            fetchOptions = new FetchOptions(fetchOptions).compile(true);
        }
        return this.runAsyncQuery(this.query, fetchOptions);
    }

    public Future<Integer> countEntitiesAsync() {
        DatastorePb.Query queryProto = this.convertToPb(this.query, FetchOptions.Builder.withDefaults());
        Future<byte[]> fb = AsyncDatastoreHelper.makeAsyncCall("Count", queryProto);
        return new FutureAdaptor<byte[], Integer>(fb){

            @Override
            protected Integer adapt(byte[] bytes) {
                ApiBasePb.Integer64Proto resp = new ApiBasePb.Integer64Proto();
                resp.mergeFrom(bytes);
                return (int)resp.getValue();
            }
        };
    }

    private Future<QueryResultIterator<Entity>> runAsyncQuery(Query q, final FetchOptions fetchOptions) {
        DatastorePb.Query queryProto = this.convertToPb(q, fetchOptions);
        Future<byte[]> futureBytes = AsyncDatastoreHelper.makeAsyncCall("RunQuery", queryProto);
        return new FutureAdaptor<byte[], QueryResultIterator<Entity>>(futureBytes){

            @Override
            protected QueryResultIterator<Entity> adapt(byte[] bytes) {
                try {
                    DatastorePb.QueryResult result = new DatastorePb.QueryResult();
                    if (bytes != null) {
                        result.mergeFrom(bytes);
                    }
                    ImmediateFuture<DatastorePb.QueryResult> future = new ImmediateFuture<DatastorePb.QueryResult>(result);
                    QueryResultsSourceImpl src = new QueryResultsSourceImpl(null, fetchOptions, AsyncPreparedQuery.this.txn, future);
                    return new QueryResultIteratorImpl((PreparedQuery)AsyncPreparedQuery.this, (QueryResultsSource)src, fetchOptions, AsyncPreparedQuery.this.txn);
                }
                catch (NoSuchMethodError e) {
                    DatastoreService service = DatastoreServiceFactory.getDatastoreService();
                    PreparedQuery prepared = service.prepare(AsyncPreparedQuery.this.txn, AsyncPreparedQuery.this.query);
                    QueryResultIterator iterator = prepared.asQueryResultIterator();
                    return iterator;
                }
            }
        };
    }

    private DatastorePb.Query convertToPb(Query q, FetchOptions fetchOptions) {
        DatastorePb.Query queryProto = QueryTranslator.convertToPb((Query)q, (FetchOptions)fetchOptions);
        if (this.txn != null) {
            TransactionImpl.ensureTxnActive((Transaction)this.txn);
            queryProto.setTransaction(DatastoreServiceImpl.localTxnToRemoteTxn((Transaction)this.txn));
        }
        return queryProto;
    }

    public String toString() {
        return this.query.toString() + (this.txn != null ? " IN " + this.txn : "");
    }

    public Iterator<Entity> asIterator(FetchOptions fetchOptions) {
        throw new UnsupportedOperationException();
    }

    public List<Entity> asList(FetchOptions fetchOptions) {
        throw new UnsupportedOperationException();
    }

    public QueryResultList<Entity> asQueryResultList(FetchOptions fetchOptions) {
        throw new UnsupportedOperationException();
    }

    public Entity asSingleEntity() throws PreparedQuery.TooManyResultsException {
        throw new UnsupportedOperationException();
    }

    public QueryResultIterator<Entity> asQueryResultIterator(FetchOptions fetchOptions) {
        throw new UnsupportedOperationException();
    }

    public int countEntities() {
        throw new UnsupportedOperationException();
    }

    public int countEntities(FetchOptions fetchoptions) {
        return 0;
    }
}

