/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig;

import com.google.common.collect.AbstractIterator;
import com.vercer.util.Strings;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class Path
implements Comparable<Path> {
    private static final char FIELD = '.';
    private static final char META = '$';
    private static final char KEY = ':';
    private static final char[] SEPERATORS = new char[]{'.', '$', ':'};
    public static final Path EMPTY_PATH = new Path("");
    private final String value;

    public Path(String value) {
        this.value = value;
    }

    public List<Part> getParts() {
        return new AbstractList<Part>(){

            @Override
            public Part get(int index) {
                int begin = index == 0 ? 0 : Strings.nthIndexOf(Path.this.value, index, SEPERATORS);
                if (begin >= 0) {
                    int end = Strings.firstIndexOf(Path.this.value, begin + 1, SEPERATORS);
                    if (end > 0) {
                        return new Part(Path.this.value.substring(begin, end));
                    }
                    return new Part(Path.this.value.substring(begin));
                }
                return null;
            }

            @Override
            public int size() {
                if (Path.this.value.length() == 0) {
                    return 0;
                }
                int index = 0;
                int count = 0;
                do {
                    index = Strings.firstIndexOf(Path.this.value, index + 2, SEPERATORS);
                    ++count;
                } while (index > 0);
                return count;
            }

            @Override
            public Iterator<Part> iterator() {
                return new AbstractIterator<Part>(){
                    private int index;

                    protected Part computeNext() {
                        if (this.index < 0) {
                            return null;
                        }
                        int nextIndex = Strings.firstIndexOf(Path.this.value, this.index + 1, SEPERATORS);
                        String substring = nextIndex > 0 ? Path.this.value.substring(this.index, nextIndex) : Path.this.value.substring(this.index);
                        this.index = nextIndex;
                        return new Part(substring);
                    }
                };
            }
        };
    }

    public Path tail(int start) {
        int index = Strings.nthIndexOf(this.value, start, SEPERATORS);
        return new Path(this.value.substring(index));
    }

    public Path head() {
        int index = Strings.lastIndexOf(this.value, this.value.length() - 1, SEPERATORS);
        return new Path(this.value.substring(0, index));
    }

    public Path head(int end) {
        int index = Strings.nthIndexOf(this.value, end, SEPERATORS);
        return new Path(this.value.substring(0, index));
    }

    public Part firstPart() {
        int index = Strings.firstIndexOf(this.value, SEPERATORS);
        if (index > 0) {
            return new Part(this.value.substring(0, index));
        }
        return new Part(this.value);
    }

    public boolean isEmpty() {
        return this.value.length() == 0;
    }

    public boolean isAbsolute() {
        char c = this.value.charAt(0);
        for (char seperator : SEPERATORS) {
            if (c != seperator) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this.value;
    }

    public boolean hasPrefix(Path path) {
        return path.isEmpty() || this.value.startsWith(path.value) && (this.value.length() == path.value.length() || this.isSeperator(this.value.charAt(path.value.length())));
    }

    private boolean isSeperator(char c) {
        for (char sperator : SEPERATORS) {
            if (c != sperator) continue;
            return true;
        }
        return false;
    }

    public Part firstPartAfterPrefix(Path prefix) {
        assert (this.hasPrefix(prefix));
        return this.getParts().get(prefix.getParts().size());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Path)) {
            return false;
        }
        Path other = (Path)obj;
        return this.value.equals(other.value);
    }

    @Override
    public int compareTo(Path o) {
        return this.value.compareTo(o.value);
    }

    public static Builder builder(Path path) {
        return new Builder(path);
    }

    public static class Part {
        private final String text;

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Part other = (Part)obj;
            return !(this.text == null ? other.text != null : !this.text.equals(other.text));
        }

        private Part(String text) {
            this.text = text;
        }

        public boolean isField() {
            return this.text.charAt(0) == '.';
        }

        public boolean isMeta() {
            return this.text.charAt(0) == '$';
        }

        public boolean isRoot() {
            char c = this.text.charAt(0);
            for (char seperator : SEPERATORS) {
                if (c != seperator) continue;
                return false;
            }
            return true;
        }

        public String getName() {
            if (this.isRoot()) {
                return this.text;
            }
            return this.text.substring(1);
        }

        public int getIndex() {
            return Integer.parseInt(this.getName());
        }
    }

    public static class Builder {
        private final StringBuilder builder = new StringBuilder();

        public Builder(String property) {
            this.builder.append(property);
        }

        public Builder(Path base) {
            this.builder.append(base.toString());
        }

        public Path build() {
            return new Path(this.builder.toString());
        }

        public Builder field(String name) {
            this.ensureValidPart(name);
            if (this.builder.length() > 0) {
                this.builder.append('.');
            }
            this.builder.append(name);
            return this;
        }

        public Builder meta(String name) {
            this.builder.append('$');
            this.builder.append(name);
            return this;
        }

        public Builder key(String name) {
            this.builder.append(':');
            this.builder.append(name);
            return this;
        }

        private void ensureValidPart(String name) {
            if (Strings.firstIndexOf(name, SEPERATORS) >= 0) {
                throw new IllegalArgumentException("Path parts cannot contain " + Arrays.toString(SEPERATORS));
            }
        }

        public Builder append(Path tail) {
            assert (!tail.isAbsolute());
            this.builder.append(tail.value);
            return this;
        }

        public Builder append(Part part) {
            assert (this.builder.length() == 0 || !part.isRoot());
            this.builder.append(part.text);
            return this;
        }
    }
}

