/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.annotation;

import com.google.code.twig.annotation.Activate;
import com.google.code.twig.annotation.Child;
import com.google.code.twig.annotation.Embed;
import com.google.code.twig.annotation.Embedded;
import com.google.code.twig.annotation.Entity;
import com.google.code.twig.annotation.Id;
import com.google.code.twig.annotation.Independent;
import com.google.code.twig.annotation.Index;
import com.google.code.twig.annotation.Key;
import com.google.code.twig.annotation.Parent;
import com.google.code.twig.annotation.Store;
import com.google.code.twig.annotation.Type;
import com.google.code.twig.annotation.Version;
import com.google.code.twig.configuration.Configuration;
import com.google.code.twig.configuration.DefaultConfiguration;
import com.google.code.twig.util.generic.GenericTypeReflector;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class AnnotationConfiguration
extends DefaultConfiguration
implements Configuration {
    private final boolean indexed;

    public AnnotationConfiguration(boolean indexPropertiesDefault, int defaultVersion) {
        super(defaultVersion);
        this.indexed = indexPropertiesDefault;
    }

    public AnnotationConfiguration(boolean indexPropertiesDefault) {
        this(indexPropertiesDefault, 0);
    }

    @Override
    public boolean child(Field field) {
        return field.isAnnotationPresent(Child.class);
    }

    @Override
    public boolean parent(Field field) {
        return field.isAnnotationPresent(Parent.class);
    }

    @Override
    public boolean embed(Field field) {
        Embedded annotation = field.getAnnotation(Embedded.class);
        if (annotation == null) {
            annotation = field.getType().getAnnotation(Embedded.class);
        }
        if (annotation != null) {
            return annotation.value();
        }
        Embed oldAnnotation = field.getAnnotation(Embed.class);
        if (oldAnnotation == null) {
            oldAnnotation = field.getType().getAnnotation(Embed.class);
        }
        if (oldAnnotation != null) {
            return oldAnnotation.value();
        }
        return false;
    }

    @Override
    public boolean store(Field field) {
        Store annotation = field.getAnnotation(Store.class);
        if (annotation != null) {
            return annotation.value();
        }
        int modifiers = field.getModifiers();
        if (Modifier.isTransient(modifiers)) {
            return false;
        }
        if (Modifier.isFinal(modifiers)) {
            String name = field.getName();
            if (name.matches(".*this\\$[0-9]+")) {
                throw new IllegalStateException("Inner class " + field.getDeclaringClass() + " must be declared static");
            }
            throw new IllegalStateException("Final field " + field + " cannot be stored");
        }
        return true;
    }

    @Override
    public boolean index(Field field) {
        Index annotation = field.getDeclaringClass().getAnnotation(Index.class);
        if (field.getAnnotation(Index.class) != null) {
            annotation = field.getAnnotation(Index.class);
        }
        if (annotation != null) {
            return annotation.value();
        }
        return this.indexed;
    }

    @Override
    public boolean id(Field field) {
        return field.isAnnotationPresent(Key.class) || field.isAnnotationPresent(Id.class);
    }

    @Override
    public java.lang.reflect.Type typeOf(Field field) {
        Type annotation = field.getAnnotation(Type.class);
        if (annotation == null) {
            return super.typeOf(field);
        }
        return annotation.value();
    }

    @Override
    public boolean polymorphic(Field field) {
        Embedded annotation = field.getAnnotation(Embedded.class);
        if (annotation == null) {
            annotation = field.getType().getAnnotation(Embedded.class);
        }
        if (annotation != null) {
            return annotation.polymorphic();
        }
        return !Modifier.isFinal(field.getType().getModifiers());
    }

    @Override
    public boolean entity(Field field) {
        return field.isAnnotationPresent(Parent.class) || field.isAnnotationPresent(Child.class) || field.isAnnotationPresent(Independent.class);
    }

    @Override
    public int activationDepth(Field field, int depth) {
        Activate annotation = field.getDeclaringClass().getAnnotation(Activate.class);
        if (field.getAnnotation(Activate.class) != null) {
            annotation = field.getAnnotation(Activate.class);
        }
        if (annotation != null) {
            return annotation.value();
        }
        return depth;
    }

    @Override
    protected int version(java.lang.reflect.Type type) {
        Class<?> clazz = GenericTypeReflector.erase(type);
        if (clazz.isAnnotationPresent(Version.class)) {
            return clazz.getAnnotation(Version.class).value();
        }
        return super.version(type);
    }

    @Override
    public long allocateIdsFor(java.lang.reflect.Type type) {
        Class<?> clazz = GenericTypeReflector.erase(type);
        if (clazz.isAnnotationPresent(Entity.class)) {
            return clazz.getAnnotation(Entity.class).allocateIdsBy();
        }
        return 0L;
    }

    @Override
    public final String name(Field field) {
        Store annotation = field.getAnnotation(Store.class);
        if (annotation != null && !annotation.name().isEmpty()) {
            return annotation.name();
        }
        return super.name(field);
    }
}

