/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.configuration;

import com.google.code.twig.configuration.Configuration;
import com.google.code.twig.conversion.PrimitiveConverter;
import com.google.code.twig.util.generic.GenericTypeReflector;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class DefaultConfiguration
implements Configuration {
    private final int defaultVersion;
    private static Map<String, Type> nameToType;
    private static Map<Type, String> typeToName;
    private static final Pattern pattern;

    public DefaultConfiguration(int defaultVersion) {
        this.defaultVersion = defaultVersion;
    }

    public static void registerTypeName(Type type, String name) {
        Type existingType;
        if (nameToType == null) {
            nameToType = new ConcurrentHashMap<String, Type>();
            typeToName = new ConcurrentHashMap<Type, String>();
        }
        if ((existingType = nameToType.get(name)) != null) {
            throw new IllegalArgumentException("Kind name " + name + " was already mapped to " + existingType);
        }
        nameToType.put(name, type);
        String existingName = typeToName.get(type);
        if (existingName != null) {
            throw new IllegalArgumentException("Type " + type + " was already mapped to kind name " + existingName);
        }
        typeToName.put(type, name);
    }

    protected Type nameToType(String name) {
        try {
            Type type;
            if (nameToType != null && (type = nameToType.get(name)) != null) {
                return type;
            }
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public final Type kindToType(String name) {
        Matcher matcher = pattern.matcher(name);
        if (matcher.lookingAt()) {
            name = name.substring(matcher.end());
        }
        name = name.replaceAll("__", " ");
        name = name.replace('_', '.');
        name = name.replace(' ', '_');
        return this.nameToType(name);
    }

    @Override
    public String name(Field field) {
        String name = field.getName();
        if (name.charAt(0) == '_') {
            name = name.substring(1);
        }
        return name;
    }

    @Override
    public final String typeToKind(Type type) {
        String kind = this.typeToName(type);
        kind = kind.replace('.', ' ');
        kind = kind.replaceAll("_", "__");
        kind = kind.replace(' ', '_');
        int version = this.version(type);
        if (version > 0) {
            kind = "v" + version + "_" + kind;
        }
        return kind;
    }

    protected String typeToName(Type type) {
        String name;
        if (typeToName != null && (name = typeToName.get(type)) != null) {
            return name;
        }
        Class<?> clazz = GenericTypeReflector.erase(type);
        String kind = clazz.getName();
        return kind;
    }

    protected int version(Type type) {
        return this.defaultVersion;
    }

    @Override
    public Type typeOf(Field field) {
        return this.replaceCollectionWithList(field.getGenericType());
    }

    protected Type replaceCollectionWithList(Type type) {
        Type componentType = null;
        Class<?> erased = GenericTypeReflector.erase(type);
        if (type instanceof TypeVariable) {
            return erased;
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType arrayType = (GenericArrayType)type;
            componentType = arrayType.getGenericComponentType();
        } else if (erased.isArray()) {
            componentType = erased.getComponentType();
        } else if (Collection.class.isAssignableFrom(erased) && !ArrayList.class.isAssignableFrom(erased)) {
            Type exact = GenericTypeReflector.getExactSuperType(type, Collection.class);
            componentType = ((ParameterizedType)exact).getActualTypeArguments()[0];
        } else {
            return type;
        }
        Class<?> replaced = this.replaceCollectionWithList(componentType);
        if (GenericTypeReflector.erase(replaced).isPrimitive()) {
            replaced = PrimitiveConverter.getWrapperClassForPrimitive(replaced);
        }
        return new ReplacedListType(type, replaced);
    }

    static {
        pattern = Pattern.compile("v\\d_");
    }

    private static final class ReplacedListType
    implements ParameterizedType {
        private final Type type;
        private final Type replaced;

        private ReplacedListType(Type type, Type replaced) {
            this.type = type;
            this.replaced = replaced;
        }

        @Override
        public Type getRawType() {
            return ArrayList.class;
        }

        @Override
        public Type getOwnerType() {
            return null;
        }

        @Override
        public Type[] getActualTypeArguments() {
            return new Type[]{this.replaced};
        }

        public String toString() {
            return "(Replaced " + this.type + " with List<" + this.replaced + ">)";
        }
    }
}

