/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.conversion;

import com.google.code.twig.conversion.SpecificConverter;
import com.google.code.twig.conversion.TypeConverter;
import com.google.code.twig.util.generic.GenericTypeReflector;
import com.vercer.util.Pair;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class CombinedConverter
implements TypeConverter {
    private static Map<Pair<Type, Class<?>>, Boolean> superTypes = new ConcurrentHashMap();
    private final List<SpecificConverter<?, ?>> specifics = new ArrayList();
    private final List<TypeConverter> generals = new ArrayList<TypeConverter>();
    private final Map<Pair<Type, Type>, SpecificConverter<?, ?>> cache = new HashMap();

    @Override
    public <T> T convert(Object source, Type type) {
        if (source != null && CombinedConverter.isSuperType(type, source.getClass())) {
            return (T)source;
        }
        SpecificConverter<?, ?> specific = null;
        if (source != null) {
            specific = this.converter(source.getClass(), type);
        }
        if (specific == null) {
            for (TypeConverter general : this.generals) {
                Object result = general.convert(source, type);
                if (result == null) continue;
                if (result == NULL_VALUE) {
                    return null;
                }
                return result;
            }
            throw new IllegalStateException("Cannot convert " + source + " to " + type);
        }
        return specific.convert(source);
    }

    private static boolean isSuperType(Type type, Class<? extends Object> clazz) {
        if (type == clazz) {
            return true;
        }
        Pair<Type, Class<? extends Object>> key = new Pair<Type, Class<? extends Object>>(type, clazz);
        Boolean superType = superTypes.get(key);
        if (superType != null) {
            return superType;
        }
        boolean result = GenericTypeReflector.isSuperType(type, clazz);
        superTypes.put(key, result);
        return result;
    }

    public void append(SpecificConverter<?, ?> specific) {
        this.specifics.add(specific);
    }

    public void append(TypeConverter general) {
        this.generals.add(general);
    }

    public void prepend(TypeConverter converter) {
        this.generals.add(0, converter);
    }

    public void prepend(SpecificConverter<?, ?> converter) {
        this.specifics.add(0, converter);
    }

    public SpecificConverter<?, ?> converter(Type from, Type to) {
        Pair<Type, Type> pair = new Pair<Type, Type>(from, to);
        if (this.cache.containsKey(pair)) {
            return this.cache.get(pair);
        }
        for (SpecificConverter<?, ?> converter : this.specifics) {
            Type type = GenericTypeReflector.getExactSuperType(converter.getClass(), SpecificConverter.class);
            Type[] arguments = ((ParameterizedType)type).getActualTypeArguments();
            if (!GenericTypeReflector.isSuperType(arguments[0], from) || !GenericTypeReflector.isSuperType(to, arguments[1])) continue;
            this.cache.put(pair, converter);
            return converter;
        }
        return null;
    }
}

