/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.conversion;

import com.google.code.twig.conversion.TypeConverter;
import com.google.code.twig.util.generic.GenericTypeReflector;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PrimitiveConverter
implements TypeConverter {
    private static final Map<Class<?>, Class<?>> primitives = new HashMap();
    private static final Set<Class<?>> wrappers = new HashSet();

    @Override
    public <T> T convert(Object source, Type type) {
        Class<?> erased = GenericTypeReflector.erase(type);
        if (source == null && !erased.isPrimitive()) {
            return (T)NULL_VALUE;
        }
        Class<?> wrapper = null;
        if (erased.isPrimitive()) {
            wrapper = primitives.get(erased);
            if (source == null) {
                if (Number.class.isAssignableFrom(wrapper)) {
                    source = 0;
                } else if (Boolean.class == wrapper) {
                    source = false;
                } else if (Character.class == wrapper) {
                    source = Character.valueOf('\u0000');
                } else {
                    throw new IllegalStateException("Unkonwn primitive default " + type);
                }
            }
            if (source.getClass() == wrapper) {
                Object result = source;
                return (T)result;
            }
        } else if (wrappers.contains(erased)) {
            wrapper = erased;
        }
        if (type == String.class && (primitives.containsKey(source.getClass()) || wrappers.contains(source.getClass()))) {
            return (T)source.toString();
        }
        if (wrapper == null) {
            return null;
        }
        if (Integer.class.isAssignableFrom(wrapper)) {
            if (source instanceof Number) {
                return (T)Integer.valueOf(((Number)source).intValue());
            }
            if (source instanceof String) {
                return (T)Integer.decode((String)source);
            }
        } else if (wrapper == Long.class) {
            if (source instanceof Number) {
                return (T)Long.valueOf(((Number)source).longValue());
            }
            if (source instanceof String) {
                return (T)Long.decode((String)source);
            }
        } else if (wrapper == Float.class) {
            if (source instanceof Number) {
                return (T)Float.valueOf(((Number)source).floatValue());
            }
            if (source instanceof String) {
                return (T)Float.valueOf((String)source);
            }
        } else if (wrapper == Double.class) {
            if (source instanceof Number) {
                return (T)Double.valueOf(((Number)source).doubleValue());
            }
            if (source instanceof String) {
                return (T)Double.valueOf((String)source);
            }
        } else if (wrapper == Short.class) {
            if (source instanceof Number) {
                return (T)Short.valueOf(((Number)source).shortValue());
            }
            if (source instanceof String) {
                return (T)Short.decode((String)source);
            }
        } else if (wrapper == Byte.class) {
            if (source instanceof Number) {
                return (T)Byte.valueOf(((Number)source).byteValue());
            }
            if (source instanceof String) {
                return (T)Byte.decode((String)source);
            }
        }
        throw new IllegalArgumentException("Could not convert from " + source + " to wrapper " + wrapper);
    }

    public static Class<?> getWrapperClassForPrimitive(Class<?> primitive) {
        return primitives.get(primitive);
    }

    static {
        primitives.put(Integer.TYPE, Integer.class);
        primitives.put(Long.TYPE, Long.class);
        primitives.put(Float.TYPE, Float.class);
        primitives.put(Double.TYPE, Double.class);
        primitives.put(Boolean.TYPE, Boolean.class);
        primitives.put(Short.TYPE, Short.class);
        primitives.put(Byte.TYPE, Byte.class);
        primitives.put(Character.TYPE, Character.class);
        wrappers.addAll(primitives.values());
    }
}

