/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.standard;

import com.google.appengine.api.datastore.DatastoreService;
import com.google.appengine.api.datastore.DatastoreServiceConfig;
import com.google.appengine.api.datastore.DatastoreServiceFactory;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.EntityNotFoundException;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.Transaction;
import com.google.code.twig.ObjectDatastore;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public abstract class BaseObjectDatastore
implements ObjectDatastore {
    private DatastoreService service;
    private Transaction transaction;

    public BaseObjectDatastore() {
        this(DatastoreServiceConfig.Builder.withDefaults());
    }

    public BaseObjectDatastore(DatastoreServiceConfig config) {
        this.setConfiguration(config);
    }

    @Override
    public void setConfiguration(DatastoreServiceConfig config) {
        this.service = this.newDatastoreService(config);
    }

    protected DatastoreService newDatastoreService(DatastoreServiceConfig config) {
        return DatastoreServiceFactory.getDatastoreService((DatastoreServiceConfig)config);
    }

    protected final Key servicePut(Entity entity) {
        if (this.transaction == null) {
            return this.service.put(entity);
        }
        return this.service.put(this.transaction, entity);
    }

    protected final List<Key> servicePut(Iterable<Entity> entities) {
        if (this.transaction == null) {
            return this.service.put(entities);
        }
        return this.service.put(this.transaction, entities);
    }

    protected final PreparedQuery servicePrepare(Query query) {
        if (this.transaction == null) {
            return this.service.prepare(query);
        }
        return this.service.prepare(this.transaction, query);
    }

    protected final void serviceDelete(Collection<Key> keys) {
        if (this.transaction == null) {
            this.service.delete(keys);
        } else {
            this.service.delete(this.transaction, keys);
        }
    }

    protected final Entity serviceGet(Key key) throws EntityNotFoundException {
        if (this.transaction == null) {
            return this.service.get(key);
        }
        return this.service.get(this.transaction, key);
    }

    protected final Map<Key, Entity> serviceGet(Iterable<Key> keys) {
        if (this.transaction == null) {
            return this.service.get(keys);
        }
        return this.service.get(this.transaction, keys);
    }

    @Override
    public DatastoreService getService() {
        return this.service;
    }

    @Override
    public final Transaction getTransaction() {
        return this.transaction;
    }

    @Override
    public final Transaction beginTransaction() {
        if (this.getTransaction() != null && this.getTransaction().isActive()) {
            throw new IllegalStateException("Already in active transaction");
        }
        this.transaction = this.service.beginTransaction();
        return this.transaction;
    }

    public final void removeTransaction() {
        this.transaction = null;
    }
}

