/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.standard;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.code.twig.standard.TranslatorObjectDatastore;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class EntitySupplier {
    private final TranslatorObjectDatastore datastore;
    private List<EntitySink> sinks = new ArrayList<EntitySink>();
    private Map<Key, Entity> keysToEntities;
    private final int chunk;

    public EntitySupplier(TranslatorObjectDatastore datastore, int chunk) {
        this.datastore = datastore;
        this.chunk = chunk;
    }

    public void register(EntitySink sink) {
        this.sinks.add(sink);
    }

    public void demand() {
        HashSet<Key> orders = new HashSet<Key>(this.chunk);
        int index = 0;
        boolean added = false;
        while (orders.size() < this.chunk) {
            EntitySink sink = this.sinks.get(index);
            Key order = sink.order();
            if (order != null) {
                orders.add(order);
                added = true;
            }
            if (++index != this.sinks.size()) continue;
            index = 0;
            if (!added) break;
            added = false;
        }
        this.keysToEntities = this.datastore.serviceGet(orders);
        for (EntitySink sink : this.sinks) {
            sink.pickup();
        }
    }

    public Entity get(Key key) {
        return this.keysToEntities.get(key);
    }

    static interface EntitySink {
        public void pickup();

        public Key order();
    }
}

