/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.standard;

import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.vercer.util.reference.ObjectReference;
import com.vercer.util.reference.ReadOnlyObjectReference;
import com.vercer.util.reference.SimpleObjectReference;

public class KeySpecification {
    private String kind;
    private ObjectReference<Key> parentKeyReference;
    private Object id;

    public KeySpecification() {
    }

    public KeySpecification(String kind, Key parentKey, Object id) {
        if (id != null && !(id instanceof String) && !(id instanceof Long)) {
            throw new IllegalArgumentException("Id must be a long or String but was " + id);
        }
        this.kind = kind;
        this.id = id;
        this.parentKeyReference = parentKey == null ? null : new SimpleObjectReference<Key>(parentKey);
    }

    public Object getId() {
        return this.id;
    }

    public String getKind() {
        return this.kind;
    }

    public void setKind(String kind) {
        this.kind = kind;
    }

    public void setParentKeyReference(ObjectReference<Key> parentKeyReference) {
        this.parentKeyReference = parentKeyReference;
    }

    public ObjectReference<Key> getParentKeyReference() {
        return this.parentKeyReference;
    }

    public boolean isComplete() {
        return this.kind != null && this.id != null;
    }

    public Key toKey() {
        if (this.isComplete()) {
            if (this.parentKeyReference == null) {
                if (this.id instanceof String) {
                    return KeyFactory.createKey((String)this.kind, (String)((String)this.id));
                }
                return KeyFactory.createKey((String)this.kind, (long)((Long)this.id));
            }
            if (this.id instanceof String) {
                return KeyFactory.createKey((Key)this.parentKeyReference.get(), (String)this.kind, (String)((String)this.id));
            }
            return KeyFactory.createKey((Key)this.parentKeyReference.get(), (String)this.kind, (long)((Long)this.id));
        }
        throw new IllegalStateException("Key specification is incomplete.  You may need to define an id for instance with kind " + this.kind);
    }

    public ObjectReference<Key> toObjectReference() {
        return new ReadOnlyObjectReference<Key>(){

            @Override
            public Key get() {
                return KeySpecification.this.toKey();
            }
        };
    }

    public void merge(KeySpecification specification) {
        if (this.parentKeyReference == null) {
            this.parentKeyReference = specification.parentKeyReference;
        }
        if (this.id == null) {
            this.id = specification.id;
        }
        if (this.kind == null) {
            this.kind = specification.kind;
        }
    }

    public void setId(long id) {
        this.id = id;
    }

    public void setName(String name) {
        this.id = name;
    }
}

