/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.standard;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.code.twig.standard.TranslatorObjectDatastore;
import com.google.common.base.Function;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class PrefetchParentIterator
extends AbstractIterator<Entity> {
    private final Iterator<Entity> children;
    private Iterator<Entity> parents;
    private final int fetchBy;
    private final TranslatorObjectDatastore datastore;

    PrefetchParentIterator(Iterator<Entity> children, TranslatorObjectDatastore datastore, int fetchBy) {
        this.children = children;
        this.datastore = datastore;
        this.fetchBy = fetchBy;
    }

    protected Entity computeNext() {
        if (this.parents == null) {
            if (!this.children.hasNext()) {
                return (Entity)this.endOfData();
            }
            ArrayList<Key> keys = new ArrayList<Key>(this.fetchBy);
            for (int i = 0; i < this.fetchBy && this.children.hasNext(); ++i) {
                keys.add(this.children.next().getKey().getParent());
            }
            final Map<Key, Entity> keyToEntity = this.keysToEntities(keys);
            this.parents = Iterators.transform(keys.iterator(), (Function)new Function<Key, Entity>(){

                public Entity apply(Key from) {
                    return (Entity)keyToEntity.get(from);
                }
            });
            if (!this.parents.hasNext()) {
                return (Entity)this.endOfData();
            }
        }
        if (this.parents.hasNext()) {
            return this.parents.next();
        }
        this.parents = null;
        return this.computeNext();
    }

    protected Map<Key, Entity> keysToEntities(List<Key> keys) {
        return this.datastore.serviceGet(keys);
    }
}

