/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.standard;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyFactory;
import com.google.code.twig.LoadCommand;
import com.google.code.twig.Property;
import com.google.code.twig.Restriction;
import com.google.code.twig.standard.StandardDecodeCommand;
import com.google.code.twig.standard.StandardTypedLoadCommand;
import java.lang.reflect.Field;
import java.lang.reflect.Type;

class StandardCommonLoadCommand<C extends StandardCommonLoadCommand<C>>
extends StandardDecodeCommand
implements LoadCommand.CommonLoadCommand<C> {
    final StandardTypedLoadCommand<?> command;
    Restriction<Entity> entityRestriction;
    Restriction<Property> propertyRestriction;
    Key parentKey;

    StandardCommonLoadCommand(StandardTypedLoadCommand<?> command) {
        super(command.datastore);
        this.command = command;
    }

    @Override
    public C restrictEntities(Restriction<Entity> restriction) {
        this.entityRestriction = restriction;
        return (C)this;
    }

    @Override
    public C restrictProperties(Restriction<Property> restriction) {
        this.propertyRestriction = restriction;
        return (C)this;
    }

    @Override
    public final C parent(Object parent) {
        this.parentKey = this.datastore.associatedKey(parent);
        if (this.parentKey == null) {
            throw new IllegalArgumentException("Parent is not associated: " + parent);
        }
        return (C)this;
    }

    Key idToKey(Object id, Field keyField, String kind) {
        Key key;
        if (keyField != null) {
            Type keyType = this.datastore.getConfiguration().typeOf(keyField);
            id = this.datastore.getConverter().convert(id, keyType);
        } else if (!(id instanceof Long) || !(id instanceof String)) {
            throw new IllegalArgumentException("Id must be String or Long but was " + id.getClass());
        }
        if (id instanceof Number) {
            long longValue = ((Number)id).longValue();
            key = this.parentKey == null ? KeyFactory.createKey((String)kind, (long)longValue) : KeyFactory.createKey((Key)this.parentKey, (String)kind, (long)longValue);
        } else {
            String keyName = (String)this.datastore.getConverter().convert(id, (Type)((Object)String.class));
            key = this.parentKey == null ? KeyFactory.createKey((String)kind, (String)keyName) : KeyFactory.createKey((Key)this.parentKey, (String)kind, (String)keyName);
        }
        return key;
    }
}

