/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.standard;

import com.google.appengine.api.datastore.AsyncDatastoreHelper;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.KeyRange;
import com.google.appengine.api.datastore.Transaction;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.code.twig.Path;
import com.google.code.twig.Property;
import com.google.code.twig.PropertyTranslator;
import com.google.code.twig.StoreCommand;
import com.google.code.twig.standard.KeySpecification;
import com.google.code.twig.standard.StandardEncodeCommand;
import com.google.code.twig.standard.StandardStoreCommand;
import com.vercer.util.reference.ObjectReference;
import com.vercer.util.reference.SimpleObjectReference;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;

abstract class StandardCommonStoreCommand<T, C extends StandardCommonStoreCommand<T, C>>
extends StandardEncodeCommand
implements StoreCommand.CommonStoreCommand<T, C> {
    final StandardStoreCommand command;
    Collection<? extends T> instances;
    List<?> ids;
    Key parentKey;
    boolean batch;
    boolean unique;

    StandardCommonStoreCommand(StandardStoreCommand command) {
        super(command.datastore);
        this.command = command;
    }

    @Override
    public final C parent(Object parent) {
        this.parentKey = this.datastore.associatedKey(parent);
        if (this.parentKey == null) {
            throw new IllegalArgumentException("Parent is not associated: " + parent);
        }
        return (C)this;
    }

    final C parentKey(Key parentKey) {
        this.parentKey = parentKey;
        return (C)this;
    }

    @Override
    public final C batch() {
        this.batch = true;
        return (C)this;
    }

    @Override
    public final C ensureUniqueKey() {
        this.unique = true;
        return (C)this;
    }

    final void checkUniqueKeys(Collection<Entity> entities) {
        ArrayList<Key> keys = new ArrayList<Key>(entities.size());
        for (Entity entity : entities) {
            keys.add(entity.getKey());
        }
        Map<Key, Entity> map = this.datastore.serviceGet(keys);
        if (!map.isEmpty()) {
            throw new IllegalStateException("Keys already exist: " + map);
        }
    }

    protected void setInstanceId(Object instance, Key key) {
        Field field = this.datastore.keyField(instance.getClass());
        try {
            Object current;
            if (field != null && ((current = field.get(instance)) == null || current instanceof Number && ((Number)current).longValue() == 0L)) {
                Class<?> type = field.getType();
                Object idOrName = key.getId();
                if (idOrName == null) {
                    idOrName = key.getName();
                }
                Object converted = this.datastore.getConverter().convert(idOrName, type);
                field.set(instance, converted);
            }
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    final Future<Map<T, Key>> storeInstancesLater() {
        final Map<T, Entity> entities = this.instancesToEntities();
        Transaction transaction = this.datastore.getTransaction();
        Future<List<Key>> put = AsyncDatastoreHelper.put(transaction, entities.values());
        return new FutureWrapper<List<Key>, Map<T, Key>>(put){

            protected Throwable convertException(Throwable t) {
                return t;
            }

            protected Map<T, Key> wrap(List<Key> keys) throws Exception {
                return StandardCommonStoreCommand.this.createKeyMapAndUpdateCache(entities, keys);
            }
        };
    }

    final Map<T, Entity> instancesToEntities() {
        LinkedHashMap<Object, Entity> entities = new LinkedHashMap<Object, Entity>(this.instances.size());
        if (this.batch) {
            this.datastore.batched = entities;
        }
        if (this.unique) {
            this.checkUniqueKeys(entities.values());
        }
        for (T instance : this.instances) {
            Entity entity = this.instanceToEntity(instance, this.parentKey, null);
            entities.put(instance, entity);
        }
        if (this.batch) {
            this.datastore.batched = null;
        }
        return entities;
    }

    protected Map<T, Key> createKeyMapAndUpdateCache(Map<T, Entity> entities, List<Key> keys) {
        HashMap<T, Key> result = new HashMap<T, Key>(keys.size());
        Iterator<T> instances = entities.keySet().iterator();
        Iterator<Key> keyor = keys.iterator();
        while (instances.hasNext()) {
            Key key = keyor.next();
            T instance = instances.next();
            result.put(instance, key);
            this.datastore.associate(instance, key);
            this.setInstanceId(instance, key);
        }
        return result;
    }

    protected Entity instanceToEntity(Object instance, Key parentKey, Object id) {
        String kind = this.datastore.getConfiguration().typeToKind(instance.getClass());
        KeySpecification existingEncodeKeySpec = this.datastore.encodeKeySpec;
        this.datastore.encodeKeySpec = new KeySpecification(kind, parentKey, id);
        if (this.command.update) {
            Key associatedKey = this.datastore.associatedKey(instance);
            if (associatedKey.getName() == null) {
                this.datastore.encodeKeySpec.setId(associatedKey.getId());
            } else {
                this.datastore.encodeKeySpec.setName(associatedKey.getName());
            }
            if (associatedKey.getParent() != null) {
                this.datastore.encodeKeySpec.setParentKeyReference(new SimpleObjectReference<Key>(associatedKey.getParent()));
            }
        } else {
            this.datastore.keyCache.cacheKeyReferenceForInstance(instance, this.datastore.encodeKeySpec.toObjectReference());
        }
        PropertyTranslator encoder = this.datastore.encoder(instance);
        Set<Property> properties = encoder.encode(instance, Path.EMPTY_PATH, this.datastore.indexed);
        if (properties == null) {
            throw new IllegalStateException("Could not translate instance: " + instance);
        }
        this.maybeSetAllocatedId(instance);
        Entity entity = this.createEntity();
        this.transferProperties(entity, properties);
        if (this.datastore.batched != null) {
            this.datastore.batched.put(instance, entity);
        }
        this.datastore.encodeKeySpec = existingEncodeKeySpec;
        return entity;
    }

    private void maybeSetAllocatedId(Object instance) {
        long allocateIdsForType = this.datastore.getConfiguration().allocateIdsFor(instance.getClass());
        if (allocateIdsForType > 0L && this.datastore.encodeKeySpec.getId() == null) {
            String kindAndParent;
            KeyRange range;
            Key parentKey = null;
            ObjectReference<Key> parentKeyReference = this.datastore.encodeKeySpec.getParentKeyReference();
            StringBuilder kindAndParentBuilder = new StringBuilder();
            kindAndParentBuilder.append(this.datastore.encodeKeySpec.getKind());
            if (parentKeyReference != null) {
                parentKey = parentKeyReference.get();
                kindAndParentBuilder.append(parentKey.toString());
            }
            if ((range = this.datastore.allocatedIdRanges.get(kindAndParent = kindAndParentBuilder.toString())) == null || !range.iterator().hasNext()) {
                range = this.datastore.getService().allocateIds(parentKeyReference.get(), this.datastore.encodeKeySpec.getKind(), allocateIdsForType);
            }
            this.datastore.encodeKeySpec.setId(((Key)range.iterator().next()).getId());
        }
    }

    protected Key entityToKey(Entity entity) {
        if (this.datastore.associating || this.batch) {
            Key key = entity.getKey();
            if (!key.isComplete()) {
                throw new IllegalArgumentException("Associating entity does not have complete key: " + entity);
            }
            return key;
        }
        return this.datastore.servicePut(entity);
    }

    protected List<Key> entitiesToKeys(Collection<Entity> entities) {
        if (this.datastore.associating || this.batch) {
            ArrayList<Key> keys = new ArrayList<Key>(entities.size());
            for (Entity entity : entities) {
                Key key = entity.getKey();
                if (!key.isComplete()) {
                    throw new IllegalArgumentException("Associating entity does not have complete key: " + entity);
                }
                keys.add(key);
            }
            return keys;
        }
        return this.datastore.servicePut(entities);
    }
}

