/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.standard;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.code.twig.Property;
import com.google.code.twig.standard.StandardCommand;
import com.google.code.twig.standard.TranslatorObjectDatastore;
import com.google.code.twig.util.Entities;
import com.vercer.util.reference.ObjectReference;
import java.util.Collection;
import java.util.List;

class StandardEncodeCommand
extends StandardCommand {
    StandardEncodeCommand(TranslatorObjectDatastore datastore) {
        super(datastore);
    }

    final Entity createEntity() {
        if (this.datastore.encodeKeySpec.isComplete()) {
            return new Entity(this.datastore.encodeKeySpec.toKey());
        }
        ObjectReference<Key> parentKeyReference = this.datastore.encodeKeySpec.getParentKeyReference();
        Key parentKey = parentKeyReference == null ? null : parentKeyReference.get();
        return Entities.createEntity(this.datastore.encodeKeySpec.getKind(), null, parentKey);
    }

    final void transferProperties(Entity entity, Collection<Property> properties) {
        for (Property property : properties) {
            Object value = property.getValue();
            value = this.dereferencePropertyValue(value);
            if (property.isIndexed()) {
                entity.setProperty(property.getPath().toString(), value);
                continue;
            }
            entity.setUnindexedProperty(property.getPath().toString(), value);
        }
    }

    final Object dereferencePropertyValue(Object value) {
        if (value instanceof ObjectReference) {
            value = ((ObjectReference)value).get();
        } else if (value instanceof List) {
            List values = (List)value;
            for (int i = 0; i < values.size(); ++i) {
                Object item = values.get(i);
                if (!(item instanceof ObjectReference)) continue;
                Object dereferenced = ((ObjectReference)item).get();
                values.set(i, dereferenced);
            }
        }
        return value;
    }
}

