/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.standard;

import com.google.appengine.api.datastore.Cursor;
import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.Key;
import com.google.appengine.api.datastore.PreparedQuery;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QueryResultIterator;
import com.google.appengine.api.utils.FutureWrapper;
import com.google.code.twig.CommandTerminator;
import com.google.code.twig.FindCommand;
import com.google.code.twig.standard.StandardCommonFindCommand;
import com.google.code.twig.standard.StandardMultipleParentsCommand;
import com.google.code.twig.standard.StandardSingleParentsCommand;
import com.google.code.twig.standard.TranslatorObjectDatastore;
import com.google.code.twig.util.FutureAdaptor;
import com.google.common.collect.ForwardingIterator;
import com.google.common.collect.Lists;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class StandardRootFindCommand<T>
extends StandardCommonFindCommand<FindCommand.RootFindCommand<T>>
implements FindCommand.RootFindCommand<T> {
    private final Type type;
    private FetchOptions options;
    private Object ancestor;
    List<Sort> sorts;
    private boolean keysOnly;

    StandardRootFindCommand(Type type, TranslatorObjectDatastore datastore) {
        super(datastore);
        this.type = type;
    }

    @Override
    StandardRootFindCommand<T> getRootCommand() {
        return this;
    }

    @Override
    public FindCommand.RootFindCommand<T> ancestor(Object ancestor) {
        this.ancestor = ancestor;
        return this;
    }

    @Override
    public FindCommand.RootFindCommand<T> fetchNoFields() {
        this.keysOnly = true;
        return this;
    }

    @Override
    public FindCommand.RootFindCommand<T> addSort(String field) {
        return this.addSort(field, Query.SortDirection.ASCENDING);
    }

    @Override
    public FindCommand.RootFindCommand<T> addSort(String field, Query.SortDirection direction) {
        if (this.sorts == null) {
            this.sorts = new ArrayList<Sort>(2);
        }
        this.sorts.add(new Sort(field, direction));
        return this;
    }

    @Override
    public FindCommand.RootFindCommand<T> continueFrom(Cursor cursor) {
        if (this.options == null) {
            this.options = FetchOptions.Builder.withDefaults();
        }
        this.options.startCursor(cursor);
        return this;
    }

    @Override
    public FindCommand.RootFindCommand<T> finishAt(Cursor cursor) {
        if (this.options == null) {
            this.options = FetchOptions.Builder.withDefaults();
        }
        this.options.endCursor(cursor);
        return this;
    }

    @Override
    public FindCommand.RootFindCommand<T> fetchNextBy(int size) {
        if (this.options == null) {
            this.options = FetchOptions.Builder.withChunkSize((int)size);
        } else {
            this.options.chunkSize(size);
        }
        return this;
    }

    @Override
    public FindCommand.RootFindCommand<T> fetchFirst(int size) {
        if (this.options == null) {
            this.options = FetchOptions.Builder.withPrefetchSize((int)size);
        } else {
            this.options.prefetchSize(size);
        }
        return this;
    }

    @Override
    public FindCommand.RootFindCommand<T> startFrom(int offset) {
        if (this.options == null) {
            this.options = FetchOptions.Builder.withOffset((int)offset);
        } else {
            this.options.offset(offset);
        }
        return this;
    }

    @Override
    public FindCommand.RootFindCommand<T> fetchMaximum(int limit) {
        if (this.options == null) {
            this.options = FetchOptions.Builder.withLimit((int)limit);
        } else {
            this.options.limit(limit);
        }
        return this;
    }

    @Override
    public Future<QueryResultIterator<T>> later() {
        Collection<Query> queries = this.getValidatedQueries();
        if (queries.size() > 1) {
            throw new IllegalStateException("Multiple queries defined");
        }
        Query query = queries.iterator().next();
        final Future<QueryResultIterator<Entity>> futureEntities = this.futureSingleQueryEntities(query);
        return new Future<QueryResultIterator<T>>(){

            private QueryResultIterator<T> doGet(QueryResultIterator<Entity> entities) {
                Iterator<Entity> iterator = StandardRootFindCommand.this.applyEntityFilter((Iterator<Entity>)entities);
                Iterator instances = StandardRootFindCommand.this.entitiesToInstances(iterator, StandardRootFindCommand.this.propertyRestriction);
                return new BasicQueryResultIterator(instances, entities);
            }

            @Override
            public QueryResultIterator<T> get() throws InterruptedException, ExecutionException {
                return this.doGet((QueryResultIterator<Entity>)((QueryResultIterator)futureEntities.get()));
            }

            @Override
            public QueryResultIterator<T> get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
                return this.doGet((QueryResultIterator<Entity>)((QueryResultIterator)futureEntities.get(timeout, unit)));
            }

            @Override
            public boolean isCancelled() {
                return futureEntities.isCancelled();
            }

            @Override
            public boolean isDone() {
                return futureEntities.isDone();
            }

            @Override
            public boolean cancel(boolean mayInterruptIfRunning) {
                return futureEntities.cancel(mayInterruptIfRunning);
            }
        };
    }

    @Override
    public CommandTerminator<Integer> returnCount() {
        return new CommandTerminator<Integer>(){

            @Override
            public Integer now() {
                Collection<Query> queries = StandardRootFindCommand.this.getValidatedQueries();
                if (queries.size() > 1) {
                    throw new IllegalStateException("Too many queries");
                }
                Query query = queries.iterator().next();
                PreparedQuery prepared = StandardRootFindCommand.this.datastore.servicePrepare(query);
                if (StandardRootFindCommand.this.options == null) {
                    StandardRootFindCommand.this.options = FetchOptions.Builder.withDefaults();
                }
                return prepared.countEntities(StandardRootFindCommand.this.options);
            }

            @Override
            public Future<Integer> later() {
                throw new UnsupportedOperationException("Not implemented yet. Depends on async count");
            }
        };
    }

    @Override
    public CommandTerminator<T> returnUnique() {
        return new CommandTerminator<T>(){

            @Override
            public T now() {
                return this.uniqueOrNull((Iterator)StandardRootFindCommand.this.now());
            }

            private T uniqueOrNull(Iterator<T> iterator) {
                if (iterator.hasNext()) {
                    Object result = iterator.next();
                    if (iterator.hasNext()) {
                        Object extra = iterator.next();
                        throw new IllegalStateException("Found more than one result " + extra);
                    }
                    return result;
                }
                return null;
            }

            @Override
            public Future<T> later() {
                Future future = StandardRootFindCommand.this.later();
                return new FutureAdaptor<QueryResultIterator<T>, T>(future){

                    @Override
                    protected T adapt(QueryResultIterator<T> source) {
                        return this.uniqueOrNull(source);
                    }
                };
            }
        };
    }

    @Override
    public CommandTerminator<List<T>> returnAll() {
        if (this.options != null && this.options.getLimit() != null) {
            this.fetchFirst(this.options.getLimit());
        } else {
            this.fetchFirst(Integer.MAX_VALUE);
        }
        return new CommandTerminator<List<T>>(){

            @Override
            public List<T> now() {
                return Lists.newArrayList(StandardRootFindCommand.this.now());
            }

            @Override
            public Future<List<T>> later() {
                Future future = StandardRootFindCommand.this.later();
                return new FutureAdaptor<QueryResultIterator<T>, List<T>>(future){

                    @Override
                    protected List<T> adapt(QueryResultIterator<T> source) {
                        ArrayList<Object> result = new ArrayList<Object>();
                        while (source.hasNext()) {
                            result.add(source.next());
                        }
                        return result;
                    }
                };
            }
        };
    }

    @Override
    public <P> CommandTerminator<Iterator<P>> returnParents() {
        return new CommandTerminator<Iterator<P>>(){

            @Override
            public Iterator<P> now() {
                return (Iterator)StandardRootFindCommand.this.parentsCommandNow().now();
            }

            @Override
            public Future<Iterator<P>> later() {
                return StandardRootFindCommand.this.parentsCommandNow().later();
            }
        };
    }

    @Override
    public <P> CommandTerminator<FindCommand.ParentsCommand<P>> returnParentsCommand() {
        return new CommandTerminator<FindCommand.ParentsCommand<P>>(){

            @Override
            public FindCommand.ParentsCommand<P> now() {
                return StandardRootFindCommand.this.parentsCommandNow();
            }

            @Override
            public Future<FindCommand.ParentsCommand<P>> later() {
                Future<Iterator<Entity>> futureEntityIterator = StandardRootFindCommand.this.futureEntityIterator();
                return new FutureAdaptor<Iterator<Entity>, FindCommand.ParentsCommand<P>>(futureEntityIterator){

                    @Override
                    protected FindCommand.ParentsCommand<P> adapt(Iterator<Entity> source) {
                        return new StandardSingleParentsCommand(StandardRootFindCommand.this, source);
                    }
                };
            }
        };
    }

    public <P> FindCommand.ParentsCommand<P> parentsCommandNow() {
        Collection<Query> queries = this.queries();
        if (queries.size() == 1) {
            Object childEntities = this.nowSingleQueryEntities(queries.iterator().next());
            childEntities = this.applyEntityFilter((Iterator<Entity>)childEntities);
            return new StandardSingleParentsCommand(this, (Iterator<Entity>)childEntities);
        }
        try {
            ArrayList<Iterator<Entity>> childIterators = new ArrayList<Iterator<Entity>>(queries.size());
            List<Future<QueryResultIterator<Entity>>> futures = this.multiQueriesToFutureEntityIterators(queries);
            for (Future<QueryResultIterator<Entity>> future : futures) {
                childIterators.add((Iterator<Entity>)future.get());
            }
            Query query = queries.iterator().next();
            List sorts = query.getSortPredicates();
            if (!query.isKeysOnly()) {
                Iterator<Entity> childEntities = this.mergeEntities(childIterators, sorts);
                childEntities = this.applyEntityFilter(childEntities);
                return new StandardSingleParentsCommand(this, childEntities);
            }
            return new StandardMultipleParentsCommand(this, childIterators, sorts);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public <P> Future<FindCommand.ParentsCommand<P>> parentsCommandLater() {
        Future<Iterator<Entity>> futureEntityIterator = this.futureEntityIterator();
        return new FutureWrapper<Iterator<Entity>, FindCommand.ParentsCommand<P>>(futureEntityIterator){

            protected Throwable convertException(Throwable arg0) {
                return arg0;
            }

            protected FindCommand.ParentsCommand<P> wrap(Iterator<Entity> childEntities) throws Exception {
                return new StandardSingleParentsCommand(StandardRootFindCommand.this, childEntities);
            }
        };
    }

    @Override
    public QueryResultIterator<T> now() {
        if (this.children == null) {
            Collection<Query> queries = this.getValidatedQueries();
            if (queries.size() > 1) {
                throw new IllegalStateException("Too many queries");
            }
            Query query = queries.iterator().next();
            QueryResultIterator<Entity> entities = this.nowSingleQueryEntities(query);
            Iterator<Entity> iterator = this.applyEntityFilter((Iterator<Entity>)entities);
            Iterator instances = this.entitiesToInstances(iterator, this.propertyRestriction);
            return new BasicQueryResultIterator(instances, entities);
        }
        try {
            final Iterator result = this.futureMultiQueryInstanceIterator().get();
            return new QueryResultIterator<T>(){

                public Cursor getCursor() {
                    throw new IllegalStateException("Cannot use cursor with merged queries");
                }

                public boolean hasNext() {
                    return result.hasNext();
                }

                public T next() {
                    return result.next();
                }

                public void remove() {
                    result.remove();
                }
            };
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw (RuntimeException)e.getCause();
        }
    }

    @Override
    protected Query newQuery() {
        if (this.ancestor == null && this.datastore.getTransaction() != null) {
            throw new IllegalStateException("Find command must have an ancestor in a transaction");
        }
        Query query = new Query(this.datastore.getConfiguration().typeToKind(this.type));
        this.applyFilters(query);
        if (this.sorts != null) {
            for (Sort sort : this.sorts) {
                query.addSort(sort.field, sort.direction);
            }
        }
        if (this.ancestor != null) {
            Key key = this.datastore.associatedKey(this.ancestor);
            if (key == null) {
                throw new IllegalArgumentException("Ancestor must be loaded in same session");
            }
            query.setAncestor(key);
        }
        if (this.keysOnly) {
            query.setKeysOnly();
        }
        return query;
    }

    public FetchOptions getFetchOptions() {
        return this.options;
    }

    public boolean isKeysOnly() {
        return this.keysOnly;
    }

    private class BasicQueryResultIterator<V>
    extends ForwardingIterator<V>
    implements QueryResultIterator<V> {
        private final Iterator<V> instances;
        private final QueryResultIterator<Entity> entities;

        public BasicQueryResultIterator(Iterator<V> instances, QueryResultIterator<Entity> entities) {
            this.instances = instances;
            this.entities = entities;
        }

        protected Iterator<V> delegate() {
            return this.instances;
        }

        public Cursor getCursor() {
            return this.entities.getCursor();
        }
    }

    class Sort {
        Query.SortDirection direction;
        String field;

        public Sort(String field, Query.SortDirection direction) {
            this.direction = direction;
            this.field = field;
        }
    }
}

