/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.standard;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.code.twig.StoreCommand;
import com.google.code.twig.standard.StandardCommonStoreCommand;
import com.google.code.twig.standard.StandardStoreCommand;
import com.google.code.twig.util.FutureAdaptor;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.Future;

final class StandardSingleStoreCommand<T>
extends StandardCommonStoreCommand<T, StandardSingleStoreCommand<T>>
implements StoreCommand.SingleStoreCommand<T, StandardSingleStoreCommand<T>> {
    StandardSingleStoreCommand(StandardStoreCommand command, T instance) {
        super(command);
        this.instances = Collections.singletonList(instance);
        if (!command.update && command.datastore.associatedKey(instance) != null) {
            throw new IllegalArgumentException("Cannot store associated instance. Use update instead.");
        }
        if (command.update && command.datastore.associatedKey(instance) == null) {
            throw new IllegalArgumentException("Cannot update non-associated instance. Use store instead.");
        }
    }

    @Override
    public Future<Key> later() {
        Future resultsLater = this.storeInstancesLater();
        return new FutureAdaptor<Map<T, Key>, Key>(resultsLater){

            @Override
            protected Key adapt(Map<T, Key> keys) {
                return (Key)Iterables.getOnlyElement(keys.values());
            }
        };
    }

    @Override
    public Key now() {
        Object instance = Iterables.getOnlyElement((Iterable)this.instances);
        Object id = null;
        if (this.ids != null) {
            id = Iterables.getOnlyElement((Iterable)this.ids);
        }
        Entity entity = this.instanceToEntity(instance, this.parentKey, id);
        if (this.unique) {
            this.checkUniqueKeys(Collections.singleton(entity));
        }
        Key key = this.entityToKey(entity);
        this.datastore.associate(instance, key);
        this.setInstanceId(instance, key);
        return key;
    }

    @Override
    public StandardSingleStoreCommand<T> id(long id) {
        this.ids = Collections.singletonList(id);
        return this;
    }

    @Override
    public StandardSingleStoreCommand<T> id(String id) {
        this.ids = Collections.singletonList(id);
        return this;
    }
}

