/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.standard;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.Key;
import com.google.code.twig.standard.EntitySupplier;
import com.google.common.collect.AbstractIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class SuppliedPrefetchParentIterator
extends AbstractIterator<Entity>
implements EntitySupplier.EntitySink {
    private final Iterator<Entity> children;
    private final EntitySupplier supplier;
    private List<Key> ordered = new ArrayList<Key>();
    private Iterator<Entity> iterator;

    SuppliedPrefetchParentIterator(Iterator<Entity> children, EntitySupplier supplier) {
        this.children = children;
        this.supplier = supplier;
        supplier.register(this);
    }

    @Override
    public Key order() {
        if (this.children.hasNext()) {
            Entity child = this.children.next();
            Key parentKey = child.getKey().getParent();
            this.ordered.add(parentKey);
            return parentKey;
        }
        return null;
    }

    @Override
    public void pickup() {
        ArrayList<Entity> parents = new ArrayList<Entity>(this.ordered.size());
        for (Key parentKey : this.ordered) {
            Entity parent = this.supplier.get(parentKey);
            parents.add(parent);
        }
        this.iterator = parents.iterator();
        this.ordered.clear();
    }

    protected Entity computeNext() {
        if (this.iterator == null || !this.iterator.hasNext()) {
            if (this.children.hasNext()) {
                this.supplier.demand();
                return this.computeNext();
            }
            return (Entity)this.endOfData();
        }
        return this.iterator.next();
    }
}

