/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.standard;

import com.google.appengine.api.datastore.Entity;
import com.google.appengine.api.datastore.FetchOptions;
import com.google.appengine.api.datastore.KeyRange;
import com.google.appengine.api.datastore.Query;
import com.google.appengine.api.datastore.QueryResultIterator;
import com.google.code.twig.FindCommand;
import com.google.code.twig.Path;
import com.google.code.twig.Property;
import com.google.code.twig.PropertyTranslator;
import com.google.code.twig.annotation.Id;
import com.google.code.twig.annotation.Key;
import com.google.code.twig.configuration.Configuration;
import com.google.code.twig.conversion.CombinedConverter;
import com.google.code.twig.conversion.TypeConverter;
import com.google.code.twig.standard.BaseObjectDatastore;
import com.google.code.twig.standard.ChildRelationTranslator;
import com.google.code.twig.standard.InstanceKeyCache;
import com.google.code.twig.standard.KeyFieldTranslator;
import com.google.code.twig.standard.KeySpecification;
import com.google.code.twig.standard.ParentRelationTranslator;
import com.google.code.twig.standard.RelationTranslator;
import com.google.code.twig.standard.StandardFindCommand;
import com.google.code.twig.standard.StandardLoadCommand;
import com.google.code.twig.standard.StandardMultipleStoreCommand;
import com.google.code.twig.standard.StandardMultipleTypedLoadCommand;
import com.google.code.twig.standard.StandardSingleStoreCommand;
import com.google.code.twig.standard.StandardSingleTypedLoadCommand;
import com.google.code.twig.standard.StandardStoreCommand;
import com.google.code.twig.standard.StandardTypedLoadCommand;
import com.google.code.twig.translator.ChainedTranslator;
import com.google.code.twig.translator.ListTranslator;
import com.google.code.twig.translator.MapTranslator;
import com.google.code.twig.translator.ObjectFieldTranslator;
import com.google.code.twig.translator.PolymorphicTranslator;
import com.google.code.twig.util.EntityToKeyFunction;
import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import com.vercer.util.Reflection;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class TranslatorObjectDatastore
extends BaseObjectDatastore {
    protected final InstanceKeyCache keyCache;
    protected boolean indexed;
    protected KeySpecification encodeKeySpec;
    protected com.google.appengine.api.datastore.Key decodeKey;
    int activationDepth = Integer.MAX_VALUE;
    private final PropertyTranslator objectFieldTranslator;
    private final PropertyTranslator embedTranslator;
    private final PropertyTranslator polyMorphicComponentTranslator;
    private final PropertyTranslator parentTranslator;
    private final PropertyTranslator independantTranslator;
    private final PropertyTranslator keyFieldTranslator;
    private final PropertyTranslator childTranslator;
    private final ChainedTranslator valueTranslatorChain;
    private final PropertyTranslator defaultTranslator;
    private static final Map<Class<?>, Field> keyFields = new ConcurrentHashMap();
    boolean associating;
    Map<Object, Entity> batched;
    Map<String, KeyRange> allocatedIdRanges;
    private Object refresh;
    private final CombinedConverter converter;
    private final Configuration configuration;
    private final Function<Object, com.google.appengine.api.datastore.Key> cachedInstanceToKeyFunction = new Function<Object, com.google.appengine.api.datastore.Key>(){

        public com.google.appengine.api.datastore.Key apply(Object instance) {
            return TranslatorObjectDatastore.this.keyCache.getKey(instance);
        }
    };
    private static final Field NO_KEY_FIELD;
    private static final Function<Entity, com.google.appengine.api.datastore.Key> entityToKeyFunction;

    public TranslatorObjectDatastore(Configuration configuration) {
        this.configuration = configuration;
        this.converter = this.createTypeConverter();
        this.objectFieldTranslator = new StrategyObjectFieldTranslator(this.converter);
        this.valueTranslatorChain = this.createValueTranslatorChain();
        this.parentTranslator = new ParentRelationTranslator(this);
        this.independantTranslator = new RelationTranslator(this);
        this.keyFieldTranslator = new KeyFieldTranslator(this, this.valueTranslatorChain, this.converter);
        this.childTranslator = new ChildRelationTranslator(this);
        this.embedTranslator = new ListTranslator(new MapTranslator(this.objectFieldTranslator, this.converter));
        this.polyMorphicComponentTranslator = new ListTranslator(new MapTranslator(new PolymorphicTranslator(new ChainedTranslator(this.valueTranslatorChain, this.objectFieldTranslator), configuration), this.converter));
        this.defaultTranslator = new ListTranslator(new MapTranslator(new ChainedTranslator(this.valueTranslatorChain, this.getFallbackTranslator()), this.converter));
        this.keyCache = this.createKeyCache();
    }

    @Override
    public final StandardFindCommand find() {
        return new StandardFindCommand(this);
    }

    @Override
    public final StandardStoreCommand store() {
        return new StandardStoreCommand(this);
    }

    @Override
    public StandardLoadCommand load() {
        return new StandardLoadCommand(this);
    }

    @Override
    public final com.google.appengine.api.datastore.Key store(Object instance) {
        return ((StandardSingleStoreCommand)this.store().instance(instance)).now();
    }

    @Override
    public final com.google.appengine.api.datastore.Key store(Object instance, long id) {
        return ((StandardSingleStoreCommand)((StandardSingleStoreCommand)this.store().instance(instance)).id(id)).now();
    }

    @Override
    public final com.google.appengine.api.datastore.Key store(Object instance, String id) {
        return ((StandardSingleStoreCommand)((StandardSingleStoreCommand)this.store().instance(instance)).id(id)).now();
    }

    @Override
    public final <T> Map<T, com.google.appengine.api.datastore.Key> storeAll(Collection<? extends T> instances) {
        return ((StandardMultipleStoreCommand)this.store().instances((Collection)instances)).now();
    }

    @Override
    public final <T> QueryResultIterator<T> find(Class<? extends T> type) {
        return (QueryResultIterator)this.find().type(type).now();
    }

    @Override
    public final <T> QueryResultIterator<T> find(Class<? extends T> type, String field, Object value) {
        return (QueryResultIterator)((FindCommand.RootFindCommand)this.find().type(type).addFilter(field, Query.FilterOperator.EQUAL, value)).now();
    }

    @Override
    public <T> T load(com.google.appengine.api.datastore.Key key) {
        Object result = this.load().key(key).now();
        return result;
    }

    @Override
    public final <T> T load(Class<? extends T> type, Object id) {
        return ((StandardSingleTypedLoadCommand)((StandardTypedLoadCommand)this.load().type((Class)type)).id(id)).now();
    }

    @Override
    public final <I, T> Map<I, T> loadAll(Class<? extends T> type, Collection<? extends I> ids) {
        return ((StandardMultipleTypedLoadCommand)((StandardTypedLoadCommand)this.load().type((Class)type)).ids((Collection)ids)).now();
    }

    @Override
    public final void update(Object instance) {
        ((StandardSingleStoreCommand)this.store().update(true).instance(instance)).now();
    }

    @Override
    public void updateAll(Collection<?> instances) {
        ((StandardMultipleStoreCommand)this.store().update(true).instances(instances)).now();
    }

    @Override
    public final void storeOrUpdate(Object instance) {
        if (this.associatedKey(instance) != null) {
            this.update(instance);
        } else {
            this.store(instance);
        }
    }

    @Override
    public final void delete(Object instance) {
        com.google.appengine.api.datastore.Key key = this.keyCache.getKey(instance);
        if (key == null) {
            throw new IllegalArgumentException("Instance " + instance + " is not associated");
        }
        this.deleteKeys(Collections.singleton(key));
    }

    @Override
    public final void deleteAll(Collection<?> instances) {
        this.deleteKeys(Collections2.transform(instances, this.cachedInstanceToKeyFunction));
    }

    @Override
    public final void refresh(Object instance) {
        com.google.appengine.api.datastore.Key key = this.associatedKey(instance);
        if (key == null) {
            throw new IllegalStateException("Instance not associated with session");
        }
        this.disassociate(instance);
        this.refresh = instance;
        Object loaded = this.load().key(key).now();
        if (loaded == null) {
            throw new IllegalStateException("Instance to be refreshed could not be found");
        }
    }

    @Override
    public void refreshAll(Collection<?> instances) {
        for (Object instance : instances) {
            this.refresh(instance);
        }
    }

    protected InstanceKeyCache createKeyCache() {
        return new InstanceKeyCache();
    }

    protected PropertyTranslator decoder(Entity entity) {
        return this.objectFieldTranslator;
    }

    protected PropertyTranslator encoder(Object instance) {
        return this.objectFieldTranslator;
    }

    protected PropertyTranslator decoder(Field field, Set<Property> properties) {
        return this.translator(field);
    }

    protected PropertyTranslator encoder(Field field, Object instance) {
        return this.translator(field);
    }

    protected PropertyTranslator translator(Field field) {
        if (this.configuration.entity(field)) {
            PropertyTranslator translator = this.configuration.parent(field) ? this.parentTranslator : (this.configuration.child(field) ? this.childTranslator : this.independantTranslator);
            return translator;
        }
        if (this.configuration.id(field)) {
            return this.keyFieldTranslator;
        }
        if (this.configuration.embed(field)) {
            if (this.configuration.polymorphic(field)) {
                return this.polyMorphicComponentTranslator;
            }
            return this.embedTranslator;
        }
        return this.defaultTranslator;
    }

    protected abstract PropertyTranslator getFallbackTranslator();

    protected abstract CombinedConverter createTypeConverter();

    protected abstract ChainedTranslator createValueTranslatorChain();

    protected boolean propertiesIndexedByDefault() {
        return true;
    }

    @Override
    public final void disassociate(Object reference) {
        this.keyCache.evictInstance(reference);
    }

    @Override
    public final void disassociateAll() {
        this.keyCache.clear();
    }

    @Override
    public final void associate(Object instance, com.google.appengine.api.datastore.Key key) {
        this.keyCache.cache(key, instance);
    }

    @Override
    public final void associate(Object instance) {
        this.associating = true;
        this.store(instance);
        this.associating = false;
    }

    @Override
    public final void associateAll(Collection<?> instances) {
        this.associating = true;
        this.storeAll(instances);
        this.associating = false;
    }

    @Override
    public final com.google.appengine.api.datastore.Key associatedKey(Object instance) {
        return this.keyCache.getKey(instance);
    }

    @Override
    public final int getActivationDepth() {
        return this.activationDepth;
    }

    @Override
    public final void setActivationDepth(int depth) {
        this.activationDepth = depth;
    }

    public CombinedConverter getConverter() {
        return this.converter;
    }

    protected final PropertyTranslator getIndependantTranslator() {
        return this.independantTranslator;
    }

    protected final PropertyTranslator getChildTranslator() {
        return this.childTranslator;
    }

    protected final PropertyTranslator getParentTranslator() {
        return this.parentTranslator;
    }

    protected final PropertyTranslator getPolymorphicTranslator() {
        return this.polyMorphicComponentTranslator;
    }

    protected final PropertyTranslator getObjectFieldTranslator() {
        return this.objectFieldTranslator;
    }

    protected final PropertyTranslator getEmbedTranslator() {
        return this.embedTranslator;
    }

    protected final PropertyTranslator getKeyFieldTranslator() {
        return this.keyFieldTranslator;
    }

    protected final PropertyTranslator getDefaultTranslator() {
        return this.defaultTranslator;
    }

    protected final InstanceKeyCache getKeyCache() {
        return this.keyCache;
    }

    @Override
    public void activate(Object ... instances) {
        this.activateAll(Arrays.asList(instances));
    }

    @Override
    public void activateAll(Collection<?> instances) {
        for (Object instance : instances) {
            this.refresh(instance);
        }
    }

    protected final void setIndexed(boolean indexed) {
        this.indexed = indexed;
    }

    final Query createQuery(Type type) {
        return new Query(this.configuration.typeToKind(type));
    }

    @Override
    public final void deleteAll(Type type) {
        Query query = this.createQuery(type);
        query.setKeysOnly();
        FetchOptions options = FetchOptions.Builder.withChunkSize((int)100);
        Iterator entities = this.servicePrepare(query).asIterator(options);
        Iterator keys = Iterators.transform((Iterator)entities, entityToKeyFunction);
        UnmodifiableIterator partitioned = Iterators.partition((Iterator)keys, (int)100);
        while (partitioned.hasNext()) {
            this.deleteKeys((Collection)partitioned.next());
        }
    }

    protected void deleteKeys(Collection<com.google.appengine.api.datastore.Key> keys) {
        this.serviceDelete(keys);
        for (com.google.appengine.api.datastore.Key key : keys) {
            if (!this.keyCache.containsKey(key)) continue;
            this.keyCache.evictKey(key);
        }
    }

    Field keyField(Class<?> type) {
        Field result = null;
        if (keyFields.containsKey(type)) {
            result = keyFields.get(type);
        } else {
            List<Field> fields = Reflection.getAccessibleFields(type);
            for (Field field : fields) {
                if (!field.isAnnotationPresent(Key.class) && !field.isAnnotationPresent(Id.class)) continue;
                result = field;
                break;
            }
            if (result == null) {
                result = NO_KEY_FIELD;
            }
            keyFields.put(type, result);
        }
        if (result == NO_KEY_FIELD) {
            return null;
        }
        return result;
    }

    protected Object createInstance(Class<?> clazz) {
        return null;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    protected abstract boolean isNullStored();

    static {
        try {
            NO_KEY_FIELD = TranslatorObjectDatastore.class.getDeclaredField("NO_KEY_FIELD");
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
        entityToKeyFunction = new EntityToKeyFunction();
    }

    private final class StrategyObjectFieldTranslator
    extends ObjectFieldTranslator {
        private StrategyObjectFieldTranslator(TypeConverter converters) {
            super(converters);
        }

        @Override
        protected boolean indexed(Field field) {
            return TranslatorObjectDatastore.this.configuration.index(field);
        }

        @Override
        protected boolean stored(Field field) {
            return TranslatorObjectDatastore.this.configuration.store(field);
        }

        @Override
        protected Type typeFromField(Field field) {
            return TranslatorObjectDatastore.this.configuration.typeOf(field);
        }

        @Override
        protected String fieldToPartName(Field field) {
            return TranslatorObjectDatastore.this.configuration.name(field);
        }

        @Override
        protected PropertyTranslator encoder(Field field, Object instance) {
            return TranslatorObjectDatastore.this.encoder(field, instance);
        }

        @Override
        protected PropertyTranslator decoder(Field field, Set<Property> properties) {
            return TranslatorObjectDatastore.this.decoder(field, properties);
        }

        @Override
        protected Object createInstance(Class<?> clazz) {
            Object instance = TranslatorObjectDatastore.this.refresh;
            if (instance == null && (instance = TranslatorObjectDatastore.this.createInstance(clazz)) == null) {
                instance = super.createInstance(clazz);
            }
            TranslatorObjectDatastore.this.refresh = null;
            if (TranslatorObjectDatastore.this.keyCache.getInstance(TranslatorObjectDatastore.this.decodeKey) == null) {
                TranslatorObjectDatastore.this.keyCache.cache(TranslatorObjectDatastore.this.decodeKey, instance);
            }
            return instance;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void decode(Object instance, Field field, Path path, Set<Property> properties) {
            int existingActivationDepth = TranslatorObjectDatastore.this.activationDepth;
            try {
                TranslatorObjectDatastore.this.activationDepth = TranslatorObjectDatastore.this.configuration.activationDepth(field, TranslatorObjectDatastore.this.activationDepth);
                super.decode(instance, field, path, properties);
            }
            finally {
                TranslatorObjectDatastore.this.activationDepth = existingActivationDepth;
            }
        }

        @Override
        protected void onBeforeEncode(Path path, Object value) {
            if (!path.getParts().isEmpty() && TranslatorObjectDatastore.this.keyCache.getKey(value) != null) {
                throw new IllegalStateException("Cannot embed persistent instance " + value + " at " + path);
            }
        }

        @Override
        protected boolean isNullStored() {
            return TranslatorObjectDatastore.this.isNullStored();
        }
    }
}

