/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.translator;

import com.google.code.twig.Path;
import com.google.code.twig.Property;
import com.google.code.twig.PropertyTranslator;
import com.google.code.twig.translator.DecoratingTranslator;
import com.google.code.twig.util.PropertySets;
import com.google.code.twig.util.SimpleProperty;
import com.google.code.twig.util.SinglePropertySet;
import com.google.code.twig.util.generic.GenericTypeReflector;
import com.google.common.collect.Lists;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ListTranslator
extends DecoratingTranslator {
    public ListTranslator(PropertyTranslator chained) {
        super(chained);
    }

    @Override
    public Object decode(Set<Property> properties, Path path, Type type) {
        if (properties.isEmpty()) {
            return null;
        }
        if (PropertySets.firstValue(properties) == null) {
            return NULL_VALUE;
        }
        if (!GenericTypeReflector.erase(type).isAssignableFrom(ArrayList.class)) {
            return this.chained.decode(properties, path, type);
        }
        ArrayList propertySets = Lists.newArrayList();
        boolean complete = false;
        int index = 0;
        while (!complete) {
            complete = true;
            HashSet<SimpleProperty> result = new HashSet<SimpleProperty>(properties.size());
            for (Property property : properties) {
                Path itemPath = property.getPath();
                Object list = property.getValue();
                if (!(list instanceof List)) {
                    return this.chained.decode(properties, path, type);
                }
                List values = (List)list;
                if (values.size() <= index) continue;
                Object value = values.get(index);
                if (value != null) {
                    result.add(new SimpleProperty(itemPath, value, true));
                }
                complete = false;
            }
            if (!complete) {
                propertySets.add(result);
            }
            ++index;
        }
        Type exact = GenericTypeReflector.getExactSuperType(type, List.class);
        Type componentType = ((ParameterizedType)exact).getActualTypeArguments()[0];
        ArrayList<Object> objects = new ArrayList<Object>();
        for (Set itemProperties : propertySets) {
            Object convertedChild = this.chained.decode(itemProperties, path, componentType);
            if (convertedChild == null) {
                return null;
            }
            objects.add(convertedChild);
        }
        return objects;
    }

    @Override
    public Set<Property> encode(Object object, Path path, boolean indexed) {
        if (object == null) {
            return PropertySets.singletonPropertySet(path, null, indexed);
        }
        if (object instanceof List) {
            Collection values;
            List list = (List)object;
            if (list.isEmpty()) {
                return Collections.emptySet();
            }
            final HashMap lists = new HashMap(8);
            int count = 0;
            for (Object item : list) {
                if (item != null) {
                    Set<Property> properties = this.chained.encode(item, path, indexed);
                    if (properties == null) {
                        return this.chained.encode(object, path, indexed);
                    }
                    for (Property property : properties) {
                        Path itemPath = property.getPath();
                        ArrayList<Property> values2 = (ArrayList<Property>)lists.get(itemPath);
                        if (values2 == null) {
                            values2 = new ArrayList<Property>(4);
                            lists.put(itemPath, values2);
                        }
                        while (values2.size() < count) {
                            values2.add(null);
                        }
                        values2.add(property);
                    }
                } else {
                    values = lists.values();
                    for (List value : values) {
                        value.add(null);
                    }
                }
                ++count;
            }
            if (lists.size() == 1) {
                Path childPath = (Path)lists.keySet().iterator().next();
                List properties = (List)lists.get(childPath);
                values = new ArrayList(properties.size());
                for (Property property : properties) {
                    values.add((Object)property.getValue());
                    indexed = property.isIndexed();
                }
                return new SinglePropertySet(childPath, values, indexed);
            }
            return new AbstractSet<Property>(){

                @Override
                public Iterator<Property> iterator() {
                    return new Iterator<Property>(){
                        Iterator<Map.Entry<Path, List<Property>>> iterator;
                        {
                            this.iterator = lists.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.iterator.hasNext();
                        }

                        @Override
                        public Property next() {
                            Map.Entry<Path, List<Property>> next = this.iterator.next();
                            List<Property> properties = next.getValue();
                            boolean indexed = false;
                            ArrayList<Object> values = new ArrayList<Object>(properties.size());
                            for (Property property : properties) {
                                Object value = null;
                                if (property != null) {
                                    value = property.getValue();
                                    indexed = property.isIndexed();
                                }
                                values.add(value);
                            }
                            return new SimpleProperty(next.getKey(), values, indexed);
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }

                @Override
                public int size() {
                    return lists.size();
                }
            };
        }
        return this.chained.encode(object, path, indexed);
    }
}

