/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.translator;

import com.google.code.twig.Path;
import com.google.code.twig.Property;
import com.google.code.twig.PropertyTranslator;
import com.google.code.twig.conversion.TypeConverter;
import com.google.code.twig.translator.DecoratingTranslator;
import com.google.code.twig.util.PrefixPropertySet;
import com.google.code.twig.util.PropertySets;
import com.google.code.twig.util.generic.GenericTypeReflector;
import com.vercer.util.collections.MergeSet;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class MapTranslator
extends DecoratingTranslator {
    private final TypeConverter converter;

    public MapTranslator(PropertyTranslator delegate, TypeConverter converter) {
        super(delegate);
        this.converter = converter;
    }

    @Override
    public Object decode(Set<Property> properties, Path path, Type type) {
        if (properties.isEmpty()) {
            return null;
        }
        if (PropertySets.firstValue(properties) == null) {
            return NULL_VALUE;
        }
        if (!GenericTypeReflector.erase(type).isAssignableFrom(HashMap.class)) {
            return this.chained.decode(properties, path, type);
        }
        Collection<PrefixPropertySet> ppss = PropertySets.prefixPropertySets(properties, path);
        Type exact = GenericTypeReflector.getExactSuperType(type, Map.class);
        Type keyType = ((ParameterizedType)exact).getActualTypeArguments()[0];
        Type valueType = ((ParameterizedType)exact).getActualTypeArguments()[1];
        HashMap result = new HashMap(ppss.size());
        for (PrefixPropertySet pps : ppss) {
            Path.Part partAfterPrefix = pps.getPrefix().firstPartAfterPrefix(path);
            Object key = this.converter.convert(partAfterPrefix.getName(), keyType);
            Object value = this.chained.decode(pps.getProperties(), pps.getPrefix(), valueType);
            result.put(key, value);
        }
        return result;
    }

    @Override
    public Set<Property> encode(Object instance, Path path, boolean indexed) {
        if (!(instance instanceof Map)) {
            return this.chained.encode(instance, path, indexed);
        }
        Map map = (Map)instance;
        Set keys = map.keySet();
        MergeSet<Property> merged = new MergeSet<Property>(map.size());
        for (Object key : keys) {
            Object value = map.get(key);
            String keyString = (String)this.converter.convert(key, (Type)((Object)String.class));
            Path childPath = Path.builder(path).key(keyString).build();
            Set<Property> properties = this.chained.encode(value, childPath, indexed);
            if (properties == null) {
                return this.chained.encode(instance, path, indexed);
            }
            merged.addAll(properties);
        }
        return merged;
    }
}

