/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.translator;

import com.google.appengine.api.datastore.DataTypeUtils;
import com.google.code.twig.Path;
import com.google.code.twig.Property;
import com.google.code.twig.PropertyTranslator;
import com.google.code.twig.conversion.TypeConverter;
import com.google.code.twig.util.PrefixPropertySet;
import com.google.code.twig.util.PropertyComparator;
import com.google.code.twig.util.PropertySets;
import com.google.code.twig.util.SimpleProperty;
import com.google.code.twig.util.generic.GenericTypeReflector;
import com.vercer.util.Reflection;
import com.vercer.util.collections.MergeSet;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ObjectFieldTranslator
implements PropertyTranslator {
    private static final Comparator<Field> comparator = new Comparator<Field>(){

        @Override
        public int compare(Field o1, Field o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    private static final PropertyComparator COMPARATOR = new PropertyComparator();
    private final TypeConverter converters;
    private static Map<Class<?>, List<Field>> classFields = new ConcurrentHashMap();
    private static Map<Class<?>, Constructor<?>> constructors = new ConcurrentHashMap();

    public ObjectFieldTranslator(TypeConverter converters) {
        this.converters = converters;
    }

    @Override
    public final Object decode(Set<Property> properties, Path path, Type type) {
        Property property;
        if (properties.size() == 1 && (property = PropertySets.firstProperty(properties)).getValue() == null && property.getPath().equals(path)) {
            return NULL_VALUE;
        }
        Class<?> clazz = GenericTypeReflector.erase(type);
        Object instance = this.createInstance(clazz);
        if (!(properties instanceof SortedSet)) {
            TreeSet<Property> sorted = new TreeSet<Property>(COMPARATOR);
            sorted.addAll(properties);
            properties = sorted;
        }
        List<Field> fields = this.getSortedFields(instance);
        Iterator<PrefixPropertySet> ppss = PropertySets.prefixPropertySets(properties, path).iterator();
        PrefixPropertySet pps = null;
        for (Field field : fields) {
            if (!this.stored(field)) continue;
            String name = this.fieldToPartName(field);
            Path fieldPath = new Path.Builder(path).field(name).build();
            while (ppss.hasNext() && (pps == null || pps.getPrefix().compareTo(fieldPath) < 0)) {
                pps = ppss.next();
            }
            Set<Object> childProperties = pps == null || !fieldPath.equals(pps.getPrefix()) ? Collections.emptySet() : pps.getProperties();
            this.decode(instance, field, fieldPath, childProperties);
        }
        return instance;
    }

    protected void decode(Object instance, Field field, Path path, Set<Property> properties) {
        Object value;
        PropertyTranslator translator = this.decoder(field, properties);
        Type fieldType = this.typeFromField(field);
        this.onBeforeDecode(field, properties);
        try {
            value = translator.decode(properties, path, fieldType);
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem translating field " + field + " with properties " + properties, e);
        }
        if (value == null) {
            if (properties.isEmpty()) {
                return;
            }
            throw new IllegalStateException("Could not translate path " + path);
        }
        if (value == NULL_VALUE) {
            value = null;
        }
        this.setFieldValue(instance, field, value);
        this.onAfterDecode(field, value);
    }

    private void setFieldValue(Object instance, Field field, Object value) {
        block10: {
            Object existing;
            if (Collection.class.isAssignableFrom(field.getType())) {
                try {
                    existing = (Collection)field.get(instance);
                    if (existing != null && value != null && existing.getClass() != value.getClass()) {
                        value = this.converters.convert(value, (Type)((Object)ArrayList.class));
                        existing.clear();
                        this.typesafeAddAll((Collection)value, (Collection<?>)existing);
                        return;
                    }
                    break block10;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
            if (Map.class.isAssignableFrom(field.getType())) {
                try {
                    existing = (Map)field.get(instance);
                    if (existing != null && value != null && existing.getClass() != value.getClass()) {
                        value = this.converters.convert(value, (Type)((Object)HashMap.class));
                        existing.clear();
                        this.typesafePutAll((Map)value, (Map<?, ?>)existing);
                        return;
                    }
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        }
        value = this.converters.convert(value, field.getGenericType());
        try {
            field.set(instance, value);
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not set value " + value + " to field " + field, e);
        }
    }

    private <K, V> void typesafePutAll(Map<?, ?> value, Map<?, ?> existing) {
        existing.putAll(value);
    }

    private <T> void typesafeAddAll(Collection<?> value, Collection<?> existing) {
        existing.addAll(value);
    }

    protected void onAfterDecode(Field field, Object value) {
    }

    protected void onBeforeDecode(Field field, Set<Property> childProperties) {
    }

    protected String fieldToPartName(Field field) {
        return field.getName();
    }

    protected Type typeFromField(Field field) {
        return field.getType();
    }

    protected Object createInstance(Class<?> clazz) {
        try {
            Constructor<?> constructor = this.getNoArgsConstructor(clazz);
            return constructor.newInstance(new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Could not find no args constructor in " + clazz, e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Could not construct instance of " + clazz, e);
        }
    }

    private Constructor<?> getNoArgsConstructor(Class<?> clazz) throws NoSuchMethodException {
        Constructor<?> constructor = constructors.get(clazz);
        if (constructor == null) {
            constructor = clazz.getDeclaredConstructor(new Class[0]);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
            constructors.put(clazz, constructor);
        }
        return constructor;
    }

    @Override
    public final Set<Property> encode(Object object, Path path, boolean indexed) {
        this.onBeforeEncode(path, object);
        if (object == null) {
            return Collections.emptySet();
        }
        try {
            List<Field> fields = this.getSortedFields(object);
            MergeSet<Property> merged = new MergeSet<Property>(fields.size());
            for (Field field : fields) {
                if (!this.stored(field)) continue;
                Type type = this.typeFromField(field);
                Object value = field.get(object);
                value = this.converters.convert(value, type);
                this.onBeforeEncode(field, value);
                PropertyTranslator translator = this.encoder(field, value);
                Path childPath = new Path.Builder(path).field(this.fieldToPartName(field)).build();
                Set<Property> properties = translator.encode(value, childPath, this.indexed(field));
                if (value == NULL_VALUE) {
                    if (!this.isNullStored()) continue;
                    merged.add(new SimpleProperty(childPath, null, this.indexed(field)));
                    continue;
                }
                if (properties == null) {
                    throw new IllegalStateException("Could not translate value to properties: " + value);
                }
                merged.addAll((Collection<Property>)properties);
                this.onAfterEncode(field, properties);
            }
            this.onAfterEncode(path, merged);
            return merged;
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalArgumentException e) {
            if (DataTypeUtils.isSupportedType(object.getClass())) {
                throw new IllegalStateException("Native data type " + object.getClass() + " should not be configured as embedded");
            }
            throw e;
        }
    }

    protected void onAfterEncode(Path path, Set<Property> properties) {
    }

    protected void onBeforeEncode(Path path, Object object) {
    }

    protected void onAfterEncode(Field field, Set<Property> properties) {
    }

    protected void onBeforeEncode(Field field, Object value) {
    }

    protected List<Field> getSortedFields(Object object) {
        List<Field> fields = classFields.get(object.getClass());
        if (fields == null) {
            fields = Reflection.getAccessibleFields(object.getClass());
            Collections.sort(fields, comparator);
            classFields.put(object.getClass(), fields);
        }
        return fields;
    }

    protected abstract boolean isNullStored();

    protected abstract boolean indexed(Field var1);

    protected abstract boolean stored(Field var1);

    protected abstract PropertyTranslator encoder(Field var1, Object var2);

    protected abstract PropertyTranslator decoder(Field var1, Set<Property> var2);
}

