/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.translator;

import com.google.appengine.api.datastore.DataTypeUtils;
import com.google.code.twig.Path;
import com.google.code.twig.Property;
import com.google.code.twig.PropertyTranslator;
import com.google.code.twig.configuration.Configuration;
import com.google.code.twig.translator.DecoratingTranslator;
import com.google.code.twig.util.PathPrefixPredicate;
import com.google.code.twig.util.PropertySets;
import com.google.code.twig.util.SimpleProperty;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Sets;
import com.vercer.util.collections.PrependSet;
import java.lang.reflect.Type;
import java.util.Set;

public class PolymorphicTranslator
extends DecoratingTranslator {
    public static final String CLASS_PROPERTY = "class";
    private final Configuration strategy;

    public PolymorphicTranslator(PropertyTranslator chained, Configuration strategy) {
        super(chained);
        this.strategy = strategy;
    }

    @Override
    public Object decode(Set<Property> properties, Path prefix, Type type) {
        Path kindNamePath = new Path.Builder(prefix).meta(CLASS_PROPERTY).build();
        String kindName = (String)PropertySets.valueForPath(kindNamePath.toString(), properties);
        if (kindName != null) {
            properties = Sets.filter(properties, (Predicate)Predicates.not((Predicate)new PathPrefixPredicate(kindNamePath)));
            type = this.strategy.kindToType(kindName);
        }
        return this.chained.decode(properties, prefix, type);
    }

    @Override
    public Set<Property> encode(Object object, Path prefix, boolean indexed) {
        Set<Property> properties = this.chained.encode(object, prefix, indexed);
        if (!DataTypeUtils.isSupportedType(object.getClass())) {
            String className = this.strategy.typeToKind(object.getClass());
            Path classNamePath = new Path.Builder(prefix).meta(CLASS_PROPERTY).build();
            SimpleProperty property = new SimpleProperty(classNamePath, className, true);
            return new PrependSet<Property>(property, properties);
        }
        return properties;
    }
}

