/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.translator;

import com.google.appengine.api.datastore.Blob;
import com.google.code.twig.Path;
import com.google.code.twig.Property;
import com.google.code.twig.PropertyTranslator;
import com.google.code.twig.conversion.EngineConverters;
import com.google.code.twig.util.SimpleProperty;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Set;

public class SerializingTranslator
implements PropertyTranslator {
    private final EngineConverters.BlobToAnything blobToSerializable = new EngineConverters.BlobToAnything();
    private final EngineConverters.SerializableToBlob serializableToBlob = new EngineConverters.SerializableToBlob();

    @Override
    public final Object decode(Set<Property> properties, Path path, Type type) {
        try {
            Property property = properties.iterator().next();
            if (property.getValue() instanceof Blob) {
                Blob blob = (Blob)property.getValue();
                return this.blobToSerializable.convert(blob);
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public final Set<Property> encode(Object object, Path path, boolean indexed) {
        try {
            if (object instanceof Serializable) {
                Blob blob = this.serializableToBlob.convert((Serializable)object);
                return Collections.singleton(new SimpleProperty(path, blob, indexed));
            }
            return null;
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

