/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.util;

import com.google.code.twig.Path;
import com.google.code.twig.Property;
import com.google.code.twig.util.SimpleProperty;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;

public final class PropertyMapToSet
extends AbstractSet<Property> {
    private final Map<String, Object> properties;
    private final boolean indexed;

    public PropertyMapToSet(Map<String, Object> properties, boolean indexed) {
        this.properties = properties;
        this.indexed = indexed;
    }

    @Override
    public Iterator<Property> iterator() {
        final Iterator<Map.Entry<String, Object>> iterator = this.properties.entrySet().iterator();
        return new Iterator<Property>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Property next() {
                Map.Entry next = (Map.Entry)iterator.next();
                return new SimpleProperty(new Path((String)next.getKey()), next.getValue(), PropertyMapToSet.this.indexed);
            }

            @Override
            public void remove() {
                iterator.remove();
            }
        };
    }

    @Override
    public int size() {
        return this.properties.size();
    }
}

