/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.util;

import com.google.code.twig.Path;
import com.google.code.twig.Property;
import com.google.code.twig.util.SimpleProperty;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class SinglePropertySet
extends AbstractSet<Property>
implements Property {
    private final Path path;
    private final Object value;
    private final boolean indexed;

    public SinglePropertySet(Path path, Object value, boolean indexed) {
        this.path = path;
        this.value = value;
        this.indexed = indexed;
    }

    @Override
    public Iterator<Property> iterator() {
        return new Iterator<Property>(){
            boolean complete;

            @Override
            public boolean hasNext() {
                return !this.complete;
            }

            @Override
            public Property next() {
                if (this.hasNext()) {
                    this.complete = true;
                    return new SimpleProperty(SinglePropertySet.this.path, SinglePropertySet.this.value, SinglePropertySet.this.indexed);
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public boolean isIndexed() {
        return this.indexed;
    }
}

