/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.util;

import com.google.common.collect.AbstractIterator;
import com.google.common.collect.Iterators;
import com.google.common.collect.PeekingIterator;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.PriorityQueue;

public class SortedMergeIterator<T>
extends AbstractIterator<T> {
    private final Comparator<T> comparator;
    private PriorityQueue<PeekingIterator<T>> peekings;
    private T last;
    Comparator<PeekingIterator<T>> pc = new Comparator<PeekingIterator<T>>(){

        @Override
        public int compare(PeekingIterator<T> o1, PeekingIterator<T> o2) {
            int compare = SortedMergeIterator.this.comparator.compare(o1.peek(), o2.peek());
            return compare;
        }
    };

    public SortedMergeIterator(Comparator<T> comparator, Collection<Iterator<T>> iterators) {
        this.comparator = comparator;
        this.peekings = new PriorityQueue<PeekingIterator<T>>(iterators.size(), this.pc);
        for (Iterator<T> iterator : iterators) {
            if (!iterator.hasNext()) continue;
            PeekingIterator peeking = Iterators.peekingIterator(iterator);
            this.peekings.offer(peeking);
        }
    }

    protected T computeNext() {
        Object next = null;
        do {
            PeekingIterator<T> top;
            if ((top = this.peekings.poll()) == null) {
                return (T)this.endOfData();
            }
            next = top.next();
            if (!top.hasNext()) continue;
            this.peekings.offer(top);
        } while (this.last != null && this.comparator.compare(next, this.last) == 0);
        this.last = next;
        return (T)next;
    }
}

