/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.twig.util.generic;

import com.google.code.twig.util.generic.CaptureType;
import com.google.code.twig.util.generic.CaptureTypeImpl;
import com.google.code.twig.util.generic.GenericArrayTypeImpl;
import com.google.code.twig.util.generic.ParameterizedTypeImpl;
import com.google.code.twig.util.generic.VarMap;
import com.google.code.twig.util.generic.WildcardTypeImpl;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;

public class GenericTypeReflector {
    private static final Type UNBOUND_WILDCARD = new WildcardTypeImpl(new Type[]{Object.class}, new Type[0]);

    public static Class<?> erase(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            if (tv.getBounds().length == 0) {
                return Object.class;
            }
            return GenericTypeReflector.erase(tv.getBounds()[0]);
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType aType = (GenericArrayType)type;
            return GenericArrayTypeImpl.createArrayType(GenericTypeReflector.erase(aType.getGenericComponentType()));
        }
        throw new RuntimeException("not supported: " + type.getClass());
    }

    private static Type mapTypeParameters(Type toMapType, Type typeAndParams) {
        if (GenericTypeReflector.isMissingTypeParameters(typeAndParams)) {
            return GenericTypeReflector.erase(toMapType);
        }
        VarMap varMap = new VarMap();
        Type handlingTypeAndParams = typeAndParams;
        while (handlingTypeAndParams instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)handlingTypeAndParams;
            Class clazz = (Class)pType.getRawType();
            varMap.addAll(clazz.getTypeParameters(), pType.getActualTypeArguments());
            handlingTypeAndParams = pType.getOwnerType();
        }
        return varMap.map(toMapType);
    }

    private static boolean isMissingTypeParameters(Type type) {
        if (type instanceof Class) {
            for (Class<?> clazz = (Class<?>)type; clazz != null; clazz = clazz.getEnclosingClass()) {
                if (clazz.getTypeParameters().length == 0) continue;
                return true;
            }
            return false;
        }
        if (type instanceof ParameterizedType) {
            return false;
        }
        throw new AssertionError((Object)("Unexpected type " + type.getClass()));
    }

    public static Type addWildcardParameters(Class<?> clazz) {
        if (clazz.isArray()) {
            return GenericArrayTypeImpl.createArrayType(GenericTypeReflector.addWildcardParameters(clazz.getComponentType()));
        }
        if (GenericTypeReflector.isMissingTypeParameters(clazz)) {
            TypeVariable<Class<?>>[] vars = clazz.getTypeParameters();
            Object[] arguments = new Type[vars.length];
            Arrays.fill(arguments, UNBOUND_WILDCARD);
            Type owner = clazz.getDeclaringClass() == null ? null : GenericTypeReflector.addWildcardParameters(clazz.getDeclaringClass());
            return new ParameterizedTypeImpl(clazz, (Type[])arguments, owner);
        }
        return clazz;
    }

    public static Type getExactSuperType(Type type, Class<?> searchClass) {
        if (type instanceof ParameterizedType || type instanceof Class || type instanceof GenericArrayType) {
            Class<?> clazz = GenericTypeReflector.erase(type);
            if (searchClass == clazz) {
                return type;
            }
            if (!searchClass.isAssignableFrom(clazz)) {
                return null;
            }
        }
        for (Type superType : GenericTypeReflector.getExactDirectSuperTypes(type)) {
            Type result = GenericTypeReflector.getExactSuperType(superType, searchClass);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static Type getTypeParameter(Type type, TypeVariable<? extends Class<?>> variable) {
        Class<?> clazz = variable.getGenericDeclaration();
        Type superType = GenericTypeReflector.getExactSuperType(type, clazz);
        if (superType instanceof ParameterizedType) {
            int index = Arrays.asList(clazz.getTypeParameters()).indexOf(variable);
            return ((ParameterizedType)superType).getActualTypeArguments()[index];
        }
        return null;
    }

    public static boolean isSuperType(Type superType, Type subType) {
        if (superType instanceof ParameterizedType || superType instanceof Class || superType instanceof GenericArrayType) {
            Class<?> superClass = GenericTypeReflector.erase(superType);
            Type mappedSubType = GenericTypeReflector.getExactSuperType(GenericTypeReflector.capture(subType), superClass);
            if (mappedSubType == null) {
                return false;
            }
            if (superType instanceof Class) {
                return true;
            }
            if (mappedSubType instanceof Class) {
                return true;
            }
            if (mappedSubType instanceof GenericArrayType) {
                Type superComponentType = GenericTypeReflector.getArrayComponentType(superType);
                assert (superComponentType != null);
                Type mappedSubComponentType = GenericTypeReflector.getArrayComponentType(mappedSubType);
                assert (mappedSubComponentType != null);
                return GenericTypeReflector.isSuperType(superComponentType, mappedSubComponentType);
            }
            assert (mappedSubType instanceof ParameterizedType);
            ParameterizedType pMappedSubType = (ParameterizedType)mappedSubType;
            assert (pMappedSubType.getRawType() == superClass);
            ParameterizedType pSuperType = (ParameterizedType)superType;
            Type[] superTypeArgs = pSuperType.getActualTypeArguments();
            Type[] subTypeArgs = pMappedSubType.getActualTypeArguments();
            assert (superTypeArgs.length == subTypeArgs.length);
            for (int i = 0; i < superTypeArgs.length; ++i) {
                if (GenericTypeReflector.contains(superTypeArgs[i], subTypeArgs[i])) continue;
                return false;
            }
            return pSuperType.getOwnerType() == null || GenericTypeReflector.isSuperType(pSuperType.getOwnerType(), pMappedSubType.getOwnerType());
        }
        if (superType instanceof CaptureType) {
            if (superType.equals(subType)) {
                return true;
            }
            for (Type lowerBound : ((CaptureType)superType).getLowerBounds()) {
                if (!GenericTypeReflector.isSuperType(lowerBound, subType)) continue;
                return true;
            }
            return false;
        }
        if (superType instanceof GenericArrayType) {
            return GenericTypeReflector.isArraySupertype(superType, subType);
        }
        throw new RuntimeException("not implemented: " + superType.getClass());
    }

    private static boolean isArraySupertype(Type arraySuperType, Type subType) {
        Type superTypeComponent = GenericTypeReflector.getArrayComponentType(arraySuperType);
        assert (superTypeComponent != null);
        Type subTypeComponent = GenericTypeReflector.getArrayComponentType(subType);
        if (subTypeComponent == null) {
            return false;
        }
        return GenericTypeReflector.isSuperType(superTypeComponent, subTypeComponent);
    }

    public static Type getArrayComponentType(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz.getComponentType();
        }
        if (type instanceof GenericArrayType) {
            GenericArrayType aType = (GenericArrayType)type;
            return aType.getGenericComponentType();
        }
        return null;
    }

    private static boolean contains(Type containingType, Type containedType) {
        if (containingType instanceof WildcardType) {
            WildcardType wContainingType = (WildcardType)containingType;
            for (Type upperBound : wContainingType.getUpperBounds()) {
                if (GenericTypeReflector.isSuperType(upperBound, containedType)) continue;
                return false;
            }
            for (Type lowerBound : wContainingType.getLowerBounds()) {
                if (GenericTypeReflector.isSuperType(containedType, lowerBound)) continue;
                return false;
            }
            return true;
        }
        return containingType.equals(containedType);
    }

    public static Type[] getExactDirectSuperTypes(Type type) {
        if (type instanceof ParameterizedType || type instanceof Class) {
            int resultIndex;
            Type[] result;
            Class clazz;
            if (type instanceof ParameterizedType) {
                clazz = (Class)((ParameterizedType)type).getRawType();
            } else {
                clazz = (Class)type;
                if (clazz.isArray()) {
                    return GenericTypeReflector.getArrayExactDirectSuperTypes(clazz);
                }
            }
            Type[] superInterfaces = clazz.getGenericInterfaces();
            Type superClass = clazz.getGenericSuperclass();
            if (superClass == null) {
                result = new Type[superInterfaces.length];
                resultIndex = 0;
            } else {
                result = new Type[superInterfaces.length + 1];
                resultIndex = 1;
                result[0] = GenericTypeReflector.mapTypeParameters(superClass, type);
            }
            for (Type superInterface : superInterfaces) {
                result[resultIndex++] = GenericTypeReflector.mapTypeParameters(superInterface, type);
            }
            return result;
        }
        if (type instanceof TypeVariable) {
            TypeVariable tv = (TypeVariable)type;
            return tv.getBounds();
        }
        if (type instanceof WildcardType) {
            return ((WildcardType)type).getUpperBounds();
        }
        if (type instanceof CaptureType) {
            return ((CaptureType)type).getUpperBounds();
        }
        if (type instanceof GenericArrayType) {
            return GenericTypeReflector.getArrayExactDirectSuperTypes(type);
        }
        throw new RuntimeException("not implemented type: " + type);
    }

    private static Type[] getArrayExactDirectSuperTypes(Type arrayType) {
        Type[] result;
        int resultIndex;
        Type typeComponent = GenericTypeReflector.getArrayComponentType(arrayType);
        if (typeComponent instanceof Class && ((Class)typeComponent).isPrimitive()) {
            resultIndex = 0;
            result = new Type[3];
        } else {
            Type[] componentSupertypes = GenericTypeReflector.getExactDirectSuperTypes(typeComponent);
            result = new Type[componentSupertypes.length + 3];
            for (resultIndex = 0; resultIndex < componentSupertypes.length; ++resultIndex) {
                result[resultIndex] = GenericArrayTypeImpl.createArrayType(componentSupertypes[resultIndex]);
            }
        }
        result[resultIndex++] = Object.class;
        result[resultIndex++] = Cloneable.class;
        result[resultIndex++] = Serializable.class;
        return result;
    }

    public static Type getExactReturnType(Method m, Type type) {
        Type returnType = m.getGenericReturnType();
        Type exactDeclaringType = GenericTypeReflector.getExactSuperType(GenericTypeReflector.capture(type), m.getDeclaringClass());
        return GenericTypeReflector.mapTypeParameters(returnType, exactDeclaringType);
    }

    public static Type getExactFieldType(Field f, Type type) {
        Type returnType = f.getGenericType();
        Type exactDeclaringType = GenericTypeReflector.getExactSuperType(GenericTypeReflector.capture(type), f.getDeclaringClass());
        return GenericTypeReflector.mapTypeParameters(returnType, exactDeclaringType);
    }

    public static Type capture(Type type) {
        VarMap varMap = new VarMap();
        ArrayList<CaptureTypeImpl> toInit = new ArrayList<CaptureTypeImpl>();
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Class clazz = (Class)pType.getRawType();
            Type[] arguments = pType.getActualTypeArguments();
            TypeVariable<Class<T>>[] vars = clazz.getTypeParameters();
            Type[] capturedArguments = new Type[arguments.length];
            assert (arguments.length == vars.length);
            for (int i = 0; i < arguments.length; ++i) {
                Type argument = arguments[i];
                if (argument instanceof WildcardType) {
                    CaptureTypeImpl captured = new CaptureTypeImpl((WildcardType)argument, vars[i]);
                    argument = captured;
                    toInit.add(captured);
                }
                capturedArguments[i] = argument;
                varMap.add(vars[i], argument);
            }
            for (CaptureTypeImpl captured : toInit) {
                captured.init(varMap);
            }
            Type ownerType = pType.getOwnerType() == null ? null : GenericTypeReflector.capture(pType.getOwnerType());
            return new ParameterizedTypeImpl(clazz, capturedArguments, ownerType);
        }
        return type;
    }

    public static String getTypeName(Type type) {
        if (type instanceof Class) {
            Class clazz = (Class)type;
            return clazz.isArray() ? GenericTypeReflector.getTypeName(clazz.getComponentType()) + "[]" : clazz.getName();
        }
        return type.toString();
    }
}

