/*
 * Decompiled with CFR 0.152.
 */
package com.vercer.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Reflection {
    public static String toString(Object object) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        String name = object.getClass().getName();
        builder.append(name.substring(name.lastIndexOf(".") + 1));
        builder.append(" ");
        Iterator<Field> fields = Reflection.getAccessibleFields(object.getClass()).iterator();
        while (fields.hasNext()) {
            Object value;
            Field field = fields.next();
            String fieldName = field.getName();
            if (fieldName.startsWith("_")) {
                fieldName = fieldName.substring(1);
            }
            builder.append(fieldName);
            builder.append("=");
            try {
                value = field.get(object);
            }
            catch (Exception e) {
                return "No permitted to access field";
            }
            if (value == null) {
                builder.append("null");
            } else {
                builder.append(value.toString());
            }
            if (!fields.hasNext()) continue;
            builder.append(" ");
        }
        builder.append("]");
        return builder.toString();
    }

    public static List<Field> getAccessibleFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (!Object.class.equals(type)) {
            Field[] declaredFields;
            for (Field field : declaredFields = type.getDeclaredFields()) {
                if (Modifier.isStatic(field.getModifiers()) || field.getName().startsWith("$")) continue;
                fields.add(field);
                field.setAccessible(true);
            }
            type = type.getSuperclass();
        }
        return fields;
    }

    public static <T> T constructCopyWith(T original, Object ... arguments) throws SecurityException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException {
        Constructor<?>[] constructors = original.getClass().getConstructors();
        Constructor<?> constructor = null;
        block0: for (Constructor<?> possible : constructors) {
            Class<?>[] parameterTypes = possible.getParameterTypes();
            if (parameterTypes.length != arguments.length) continue;
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> type = parameterTypes[i];
                if (!type.isAssignableFrom(arguments[i].getClass())) continue block0;
            }
            constructor = possible;
        }
        if (constructors == null) {
            throw new IllegalArgumentException("Could not find constructor");
        }
        return constructor.newInstance(arguments);
    }
}

