/*
 * Decompiled with CFR 0.152.
 */
package com.vercer.util.collections;

import com.google.common.collect.UnmodifiableIterator;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;

public class ArraySortedSet<T>
extends AbstractSet<T>
implements SortedSet<T> {
    private final T[] elements;
    private final Comparator<? super T> comparator;
    private final int offset;
    private final int length;

    public ArraySortedSet(T[] elements, Comparator<? super T> comparator) {
        this(elements, 0, elements.length, comparator);
    }

    public ArraySortedSet(T[] elements, int offset, int length, Comparator<? super T> comparator) {
        this.elements = elements;
        this.offset = offset;
        this.length = length;
        this.comparator = comparator;
    }

    @Override
    public Object[] toArray() {
        return this.elements;
    }

    @Override
    public Iterator<T> iterator() {
        final int end = this.offset + this.length;
        return new UnmodifiableIterator<T>(){
            int i;
            {
                this.i = ArraySortedSet.this.offset;
            }

            public boolean hasNext() {
                return this.i < end;
            }

            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return ArraySortedSet.this.elements[this.i++];
            }
        };
    }

    @Override
    public int size() {
        return this.length;
    }

    @Override
    public Comparator<? super T> comparator() {
        return this.comparator;
    }

    @Override
    public T first() {
        return this.elements[0];
    }

    @Override
    public SortedSet<T> headSet(T toElement) {
        int index = Arrays.binarySearch(this.elements, toElement, this.comparator);
        return new ArraySortedSet<T>(this.elements, 0, index + 1, this.comparator);
    }

    @Override
    public T last() {
        return this.elements[this.offset + this.length - 1];
    }

    @Override
    public SortedSet<T> subSet(T fromElement, T toElement) {
        int from = Arrays.binarySearch(this.elements, fromElement);
        int to = Arrays.binarySearch(this.elements, toElement);
        return new ArraySortedSet<T>(this.elements, from, to - from + 1, this.comparator);
    }

    @Override
    public SortedSet<T> tailSet(T fromElement) {
        int index = Arrays.binarySearch(this.elements, fromElement);
        return new ArraySortedSet<T>(this.elements, index, this.length, this.comparator);
    }
}

