/*
 * Decompiled with CFR 0.152.
 */
package play.modules.useragentcheck;

import nl.bitwalker.useragentutils.Browser;
import nl.bitwalker.useragentutils.UserAgent;
import nl.bitwalker.useragentutils.Version;
import play.Logger;
import play.Play;

public class UserAgentCheck {
    private static final String INTERNET_EXPLORER = "Internet Explorer";
    private static final String OPERA = "Opera";
    private static final String FIREFOX = "Firefox";
    private static final String CHROME = "Chrome";
    private static final String SAFARI = "Safari";

    public static boolean check(String agent) {
        Logger.debug((String)"UserAgentCheck agent=%s", (Object[])new Object[]{agent});
        try {
            UserAgent userAgent = UserAgent.parseUserAgentString((String)agent);
            Browser browser = userAgent.getBrowser().getGroup();
            String browserGroupName = browser.getName();
            Version version = browser.getVersion(agent);
            String v = version.getMajorVersion();
            int majorVersion = Integer.parseInt(v);
            boolean acceptableAgent = false;
            Logger.debug((String)"UserAgentCheck name:%s version:%s", (Object[])new Object[]{browserGroupName, majorVersion});
            if (majorVersion > 0) {
                acceptableAgent = UserAgentCheck.checkAgainst(browserGroupName, INTERNET_EXPLORER, majorVersion) || UserAgentCheck.checkAgainst(browserGroupName, FIREFOX, majorVersion) || UserAgentCheck.checkAgainst(browserGroupName, CHROME, majorVersion) || UserAgentCheck.checkAgainst(browserGroupName, SAFARI, majorVersion) || UserAgentCheck.checkAgainst(browserGroupName, OPERA, majorVersion);
            }
            Logger.debug((String)"UserAgentCheck acceptable=%s", (Object[])new Object[]{acceptableAgent});
            return acceptableAgent;
        }
        catch (Exception e) {
            Logger.warn((String)"UserAgentCheck cannot be parserd %s", (Object[])new Object[]{e});
            return false;
        }
    }

    public static boolean displayBanner(String agent) {
        boolean displayBannerFlag = !UserAgentCheck.check(agent);
        Logger.debug((String)"UserAgentCheck displayBanner=%s", (Object[])new Object[]{displayBannerFlag});
        return displayBannerFlag;
    }

    private static boolean checkAgainst(String browserName, String browserMatch, int majorVersion) {
        if (!browserMatch.equals(browserName)) {
            return false;
        }
        String capEngine = browserMatch.substring(0, 1).toUpperCase() + browserMatch.substring(1).replace(" ", "").toLowerCase();
        String minVersionStr = Play.configuration.getProperty("useragentcheck.min" + capEngine + "Version");
        int minVersion = minVersionStr == null ? UserAgentCheck.getDefaultMinVersion(browserMatch) : Integer.parseInt(minVersionStr);
        return majorVersion >= minVersion;
    }

    public static int getDefaultMinVersion(String engine) {
        if (engine.equals(INTERNET_EXPLORER)) {
            return 7;
        }
        if (engine.equals(OPERA)) {
            return 9;
        }
        if (engine.equals(FIREFOX)) {
            return 5;
        }
        if (engine.equals(CHROME)) {
            return 13;
        }
        if (engine.equals(SAFARI)) {
            return 5;
        }
        return 0;
    }
}

