/*
 * Decompiled with CFR 0.152.
 */
package play.modules.useragentcheck;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.modules.useragentcheck.NoUserAgentCheck;
import play.modules.useragentcheck.UserAgentCheck;
import play.mvc.Http;
import play.mvc.Router;
import play.mvc.results.Redirect;

public class UserAgentCheckPlugin
extends PlayPlugin {
    public void beforeActionInvocation(Method actionMethod) {
        String block = Play.configuration.getProperty("useragentcheck.block");
        if (block != null && !Boolean.parseBoolean(block)) {
            return;
        }
        if (actionMethod.getDeclaringClass().getAnnotation(NoUserAgentCheck.class) != null) {
            Logger.debug((String)"@NoUserAgentCheck annotation detected", (Object[])new Object[0]);
            return;
        }
        if (actionMethod.toGenericString().equals("public static void controllers.useragentcheck.WebUserAgent.agent()")) {
            return;
        }
        boolean reverseProxyModuleAvailable = this.isReverseProxyModuleAvailable();
        Http.Request request = Http.Request.current();
        String agent = ((Http.Header)request.headers.get("user-agent")).value();
        boolean acceptableAgent = UserAgentCheck.check(agent);
        Logger.debug((String)"acceptable user-agent: %b", (Object[])new Object[]{acceptableAgent});
        if (!acceptableAgent) {
            String url = Router.reverse((String)"useragentcheck.WebUserAgent.block").url;
            if (reverseProxyModuleAvailable) {
                url = this.buildFullUrl(url);
            }
            boolean permanent = false;
            throw new Redirect(url, permanent);
        }
    }

    private boolean isReverseProxyModuleAvailable() {
        for (PlayPlugin plugin : Play.pluginCollection.getAllPlugins()) {
            if (!plugin.getClass().getName().equals("play.modules.reverseproxy.ReverseProxyPlugin") || !Play.pluginCollection.isEnabled(plugin)) continue;
            return true;
        }
        return false;
    }

    private String buildFullUrl(String path) {
        try {
            Class<?> clazz = Class.forName("play.modules.reverseproxy.utilities.UrlUtility");
            Method m = clazz.getDeclaredMethod("buildFullUrl", String.class);
            m.setAccessible(true);
            return (String)m.invoke(null, path);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }
}

