/*
 * Decompiled with CFR 0.152.
 */
package play.modules.vhost;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import play.cache.Cache;
import play.modules.vhost.VirtualHostDataSource;
import play.modules.vhost.VirtualHostListener;
import play.modules.vhost.VirtualHostsPlugin;
import play.mvc.Http;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VirtualHost {
    private String homeDir;
    private List<String> fqdns;
    private VirtualHostDataSource dataSource;
    private Map<String, String> config;
    private Map<String, Object> properties;
    Set<VirtualHostListener> listeners;

    public static VirtualHost getCurrent() {
        Http.Request currentRequest = Http.Request.current();
        return currentRequest != null ? VirtualHostsPlugin.findHost(currentRequest.domain) : null;
    }

    public static VirtualHost find(String domain) {
        return domain != null ? VirtualHostsPlugin.findHost(domain) : null;
    }

    public static VirtualHost[] getAll() {
        return VirtualHostsPlugin.getAllHosts();
    }

    public VirtualHost(String pHomeDir, List<String> pFqdns, Map<String, String> pConfig, VirtualHostDataSource ds) {
        if (pHomeDir == null || pFqdns == null) {
            throw new IllegalArgumentException("Unexpected parameter values");
        }
        this.homeDir = pHomeDir;
        this.fqdns = pFqdns;
        this.properties = new HashMap<String, Object>();
        this.config = new HashMap<String, String>();
        this.listeners = new HashSet<VirtualHostListener>();
        this.config.putAll(pConfig);
        this.dataSource = ds;
    }

    public String getHomeDir() {
        return this.homeDir;
    }

    public String getName() {
        return this.fqdns.get(0);
    }

    public List<String> getFqdns() {
        return this.fqdns;
    }

    public String getConfigProperty(String pName, String pDefault) {
        String result = this.config.get(pName);
        return result != null ? result : pDefault;
    }

    public Object getProperty(String pName) {
        return this.properties.get(pName);
    }

    public void clearProperty(String pName) {
        this.properties.remove(pName);
    }

    public Object setProperty(String pName, Object pValue) {
        return this.setProperty(pName, pValue, null);
    }

    public Object setProperty(String pName, Object pValue, VirtualHostListener pListener) {
        if (pListener != null) {
            this.listeners.add(pListener);
        }
        return this.properties.put(pName, pValue);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String cacheKey(String pKey) {
        return String.format("%d:%s", this.homeDir.hashCode(), pKey);
    }

    public <T> T cacheGet(String pKey, Class<T> pClass) {
        return (T)Cache.get((String)this.cacheKey(pKey), pClass);
    }
}

