/*
 * Decompiled with CFR 0.152.
 */
package play.modules.vhost;

import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Map;
import javax.sql.DataSource;

public class VirtualHostDataSource
implements DataSource {
    private boolean autoCommit = false;
    private DataSource target;
    private ThreadLocal<VHConnection> connection = new ThreadLocal();

    public VirtualHostDataSource(DataSource ds) {
        this.target = ds;
    }

    public Connection getConnection() throws SQLException {
        VHConnection result = this.connection.get();
        if (result == null) {
            result = new VHConnection(this, this.target.getConnection());
            if (result.target.getAutoCommit() != this.autoCommit) {
                result.target.setAutoCommit(this.autoCommit);
            }
            this.connection.set(result);
            return result;
        }
        return new VHConnection(this, result.target);
    }

    public Connection getConnection(String username, String password) throws SQLException {
        return null;
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.target.getLogWriter();
    }

    public int getLoginTimeout() throws SQLException {
        return this.target.getLoginTimeout();
    }

    public void setLogWriter(PrintWriter out) throws SQLException {
        this.target.setLogWriter(out);
    }

    public void setLoginTimeout(int seconds) throws SQLException {
        this.target.setLoginTimeout(seconds);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class VHConnection
    implements Connection {
        private Connection target;
        private VirtualHostDataSource dataSource;

        public VHConnection(VirtualHostDataSource dataSource, Connection target) {
            this.dataSource = dataSource;
            this.target = target;
        }

        @Override
        public void clearWarnings() throws SQLException {
            this.target.clearWarnings();
        }

        @Override
        public void close() throws SQLException {
            if (this == this.dataSource.connection.get()) {
                this.target.close();
                this.dataSource.connection.set(null);
            }
        }

        @Override
        public boolean isClosed() throws SQLException {
            return this.target.isClosed();
        }

        @Override
        public boolean isReadOnly() throws SQLException {
            return this.target.isReadOnly();
        }

        @Override
        public void setReadOnly(boolean readOnly) throws SQLException {
            this.target.setReadOnly(readOnly);
        }

        @Override
        public boolean getAutoCommit() throws SQLException {
            return this.target.getAutoCommit();
        }

        @Override
        public void setAutoCommit(boolean autoCommit) throws SQLException {
            if (this != this.dataSource.connection.get()) {
                return;
            }
            this.target.setAutoCommit(autoCommit);
        }

        @Override
        public void commit() throws SQLException {
            if (this != this.dataSource.connection.get()) {
                return;
            }
            this.target.commit();
        }

        @Override
        public void rollback() throws SQLException {
            if (this != this.dataSource.connection.get()) {
                return;
            }
            this.target.rollback();
        }

        @Override
        public void rollback(Savepoint savepoint) throws SQLException {
            if (this != this.dataSource.connection.get()) {
                return;
            }
            this.target.rollback(savepoint);
        }

        @Override
        public Savepoint setSavepoint() throws SQLException {
            return this.target.setSavepoint();
        }

        @Override
        public Savepoint setSavepoint(String name) throws SQLException {
            return this.target.setSavepoint(name);
        }

        @Override
        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.target.releaseSavepoint(savepoint);
        }

        @Override
        public Statement createStatement() throws SQLException {
            return this.target.createStatement();
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.target.createStatement(resultSetType, resultSetConcurrency);
        }

        @Override
        public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.target.createStatement(resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public String getCatalog() throws SQLException {
            return this.target.getCatalog();
        }

        @Override
        public int getHoldability() throws SQLException {
            return this.target.getHoldability();
        }

        @Override
        public DatabaseMetaData getMetaData() throws SQLException {
            return this.target.getMetaData();
        }

        @Override
        public int getTransactionIsolation() throws SQLException {
            return this.target.getTransactionIsolation();
        }

        @Override
        public Map<String, Class<?>> getTypeMap() throws SQLException {
            return this.target.getTypeMap();
        }

        @Override
        public SQLWarning getWarnings() throws SQLException {
            return this.target.getWarnings();
        }

        @Override
        public String nativeSQL(String sql) throws SQLException {
            return this.target.nativeSQL(sql);
        }

        @Override
        public CallableStatement prepareCall(String sql) throws SQLException {
            return this.target.prepareCall(sql);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.target.prepareCall(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.target.prepareCall(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public PreparedStatement prepareStatement(String sql) throws SQLException {
            return this.target.prepareStatement(sql);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
            return this.target.prepareStatement(sql, autoGeneratedKeys);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
            return this.target.prepareStatement(sql, columnIndexes);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
            return this.target.prepareStatement(sql, columnNames);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
            return this.target.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }

        @Override
        public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
            return this.target.prepareStatement(sql, resultSetType, resultSetConcurrency, resultSetHoldability);
        }

        @Override
        public void setCatalog(String catalog) throws SQLException {
            this.target.setCatalog(catalog);
        }

        @Override
        public void setHoldability(int holdability) throws SQLException {
            this.target.setHoldability(holdability);
        }

        @Override
        public void setTransactionIsolation(int level) throws SQLException {
            this.target.setTransactionIsolation(level);
        }

        @Override
        public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
            this.target.setTypeMap(map);
        }
    }
}

