/*
 * Decompiled with CFR 0.152.
 */
package com.den_4.inotify_java;

import java.util.EventObject;

public class InotifyEvent
extends EventObject {
    private int fileDescriptor;
    private int mask;
    private int cookie;
    private String name;

    public InotifyEvent(int fileDescriptor, int mask) {
        super(fileDescriptor);
        this.fileDescriptor = fileDescriptor;
        this.mask = mask;
    }

    public InotifyEvent(int fileDescriptor, int mask, int cookie) {
        super(fileDescriptor);
        this.fileDescriptor = fileDescriptor;
        this.mask = mask;
        this.cookie = cookie;
    }

    public InotifyEvent(int fileDescriptor, int mask, int cookie, String name) {
        super(fileDescriptor);
        this.fileDescriptor = fileDescriptor;
        this.mask = mask;
        this.cookie = cookie;
        this.name = name;
    }

    public boolean IN_ACCESS() {
        return (1 & this.mask) == 1;
    }

    public boolean isFileAccess() {
        return this.IN_ACCESS();
    }

    public boolean IN_MODIFY() {
        return (2 & this.mask) == 2;
    }

    public boolean isFileModification() {
        return this.IN_MODIFY();
    }

    public boolean IN_ATTRIB() {
        return (4 & this.mask) == 4;
    }

    public boolean isMetadataChange() {
        return this.IN_ATTRIB();
    }

    public boolean IN_CLOSE_WRITE() {
        return (8 & this.mask) == 8;
    }

    public boolean isCloseWritableFile() {
        return this.IN_CLOSE_WRITE();
    }

    public boolean IN_CLOSE_NOWRITE() {
        return (0x10 & this.mask) == 16;
    }

    public boolean isCloseUnwritableFile() {
        return this.IN_CLOSE_NOWRITE();
    }

    public boolean IN_OPEN() {
        return (0x20 & this.mask) == 32;
    }

    public boolean isOpenFile() {
        return this.IN_OPEN();
    }

    public boolean IN_MOVED_FROM() {
        return (0x40 & this.mask) == 64;
    }

    public boolean isMoveFileFrom() {
        return this.IN_MOVED_FROM();
    }

    public boolean IN_MOVED_TO() {
        return (0x80 & this.mask) == 128;
    }

    public boolean isMoveFileTo() {
        return this.IN_MOVED_TO();
    }

    public boolean IN_CREATE() {
        return (0x100 & this.mask) == 256;
    }

    public boolean isCreateFile() {
        return this.IN_CREATE();
    }

    public boolean IN_DELETE() {
        return (0x200 & this.mask) == 512;
    }

    public boolean isDeleteFile() {
        return this.IN_DELETE();
    }

    public boolean IN_DELETE_SELF() {
        return (0x400 & this.mask) == 1024;
    }

    public boolean isDeleteSelf() {
        return this.IN_DELETE_SELF();
    }

    public boolean IN_MOVE_SELF() {
        return (0x800 & this.mask) == 2048;
    }

    public boolean isMoveSelf() {
        return this.IN_MOVE_SELF();
    }

    public boolean IN_UNMOUNT() {
        return (0x2000 & this.mask) == 8192;
    }

    public boolean isUnmount() {
        return this.IN_UNMOUNT();
    }

    public boolean IN_Q_OVERFLOW() {
        return (0x4000 & this.mask) == 16384;
    }

    public boolean isQueueOverflow() {
        return this.IN_Q_OVERFLOW();
    }

    public boolean IN_IGNORED() {
        return (0x8000 & this.mask) == 32768;
    }

    public boolean isIgnored() {
        return this.IN_IGNORED();
    }

    public boolean IN_CLOSE() {
        return (0x18 & this.mask) == 24;
    }

    public boolean isCloseFile() {
        return this.IN_CLOSE();
    }

    public boolean IN_MOVE() {
        return (0xC0 & this.mask) == 192;
    }

    public boolean isMove() {
        return this.IN_MOVE();
    }

    public boolean IN_ISDIR() {
        return (0x40000000 & this.mask) == 0x40000000;
    }

    public boolean isAgainstDirectory() {
        return this.IN_ISDIR();
    }

    public boolean IN_ONESHOT() {
        return (Integer.MIN_VALUE & this.mask) == Integer.MIN_VALUE;
    }

    public boolean isOneshot() {
        return this.IN_ONESHOT();
    }

    public final int getFileDescriptor() {
        return this.fileDescriptor;
    }

    public final int getMask() {
        return this.mask;
    }

    public final int getCookie() {
        return this.cookie;
    }

    public final String getName() {
        return this.name;
    }

    public final void setFileDescriptor(int fileDescriptor) {
        this.fileDescriptor = fileDescriptor;
    }

    public final void setMask(int mask) {
        this.mask = mask;
    }

    public final void setCookie(int cookie) {
        this.cookie = cookie;
    }

    public final void setName(String name) {
        this.name = name;
    }
}

