/*
 * Decompiled with CFR 0.152.
 */
package play.modules.vhost;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import play.cache.Cache;
import play.modules.vhost.VirtualHostListener;
import play.modules.vhost.VirtualHostsPlugin;
import play.mvc.Http;

public class VirtualHost {
    private List<String> fqdns;
    private DataSource dataSource;
    Map<String, String> config;
    private Map<String, Object> properties;
    Set<VirtualHostListener> listeners;

    public static VirtualHost current() {
        Http.Request currentRequest = Http.Request.current();
        return currentRequest != null ? VirtualHostsPlugin.findHost(currentRequest.domain) : null;
    }

    public static VirtualHost find(String domain) {
        return domain != null ? VirtualHostsPlugin.findHost(domain) : null;
    }

    public static VirtualHost[] getAll() {
        return VirtualHostsPlugin.getAllHosts();
    }

    public VirtualHost(List<String> pFqdns, Map<String, String> pConfig, DataSource ds) {
        if (pFqdns == null || pFqdns.size() == 0) {
            throw new IllegalArgumentException("Unexpected parameter values");
        }
        this.fqdns = pFqdns;
        this.properties = new HashMap<String, Object>();
        this.config = new HashMap<String, String>();
        this.listeners = new HashSet<VirtualHostListener>();
        for (String key : pConfig.keySet()) {
            if (key.equals("fqdn") || key.startsWith("db.")) continue;
            this.config.putAll(pConfig);
        }
        this.dataSource = ds;
    }

    public String getName() {
        return this.fqdns.get(0);
    }

    public List<String> getFqdns() {
        return this.fqdns;
    }

    public String getConfigProperty(String pName, String pDefault) {
        String result = this.config.get(pName);
        return result != null ? result : pDefault;
    }

    public Object getProperty(String pName) {
        return this.properties.get(pName);
    }

    public void clearProperty(String pName) {
        this.properties.remove(pName);
    }

    public Object setProperty(String pName, Object pValue) {
        return this.properties.put(pName, pValue);
    }

    public void addListener(VirtualHostListener pListener) {
        if (pListener != null) {
            this.listeners.add(pListener);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String cacheKey(String pKey) {
        return String.format("%d:%s", this.fqdns.get(0).hashCode(), pKey);
    }

    public <T> T cacheGet(String pKey, Class<T> pClass) {
        return (T)Cache.get((String)this.cacheKey(pKey), pClass);
    }
}

