/*
 * Decompiled with CFR 0.152.
 */
package play.modules.vhost;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import play.modules.vhost.VirtualHostListener;
import play.modules.vhost.VirtualHostsPlugin;
import play.mvc.Http;
import play.templates.BaseTemplate;

public class VirtualHost {
    static final String CFG_HOME_DIR = "homedir";
    private List<String> fqdns;
    private DataSource dataSource;
    private Map<String, Object> properties;
    Map<String, String> config;
    Map<String, BaseTemplate> templateCache;
    Set<VirtualHostListener> listeners;

    public static VirtualHost current() {
        Http.Request currentRequest = Http.Request.current();
        return currentRequest != null ? VirtualHostsPlugin.findHost(currentRequest.domain) : null;
    }

    public static VirtualHost find(String domain) {
        return domain != null ? VirtualHostsPlugin.findHost(domain) : null;
    }

    public static VirtualHost[] getAll() {
        return VirtualHostsPlugin.getAllHosts();
    }

    public VirtualHost(List<String> pFqdns, Map<String, String> pConfig, DataSource ds) {
        if (pFqdns == null || pFqdns.size() == 0) {
            throw new IllegalArgumentException("Unexpected parameter values");
        }
        this.fqdns = pFqdns;
        this.properties = new HashMap<String, Object>();
        this.config = new HashMap<String, String>();
        this.listeners = new HashSet<VirtualHostListener>();
        this.templateCache = new HashMap<String, BaseTemplate>();
        for (String key : pConfig.keySet()) {
            if (key.toLowerCase().equals("fqdns") || key.toLowerCase().startsWith("db.")) continue;
            this.config.put(key.toLowerCase(), pConfig.get(key));
        }
        this.dataSource = ds;
    }

    public String getName() {
        return this.fqdns.get(0);
    }

    public List<String> getFqdns() {
        return this.fqdns;
    }

    public Object getProperty(String pName) {
        return this.properties.get(pName);
    }

    public void clearProperty(String pName) {
        this.properties.remove(pName);
    }

    public Object setProperty(String pName, Object pValue) {
        return this.properties.put(pName, pValue);
    }

    public void addListener(VirtualHostListener pListener) {
        if (pListener != null) {
            this.listeners.add(pListener);
        }
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public String config(String pName, String pDefault) {
        String result = this.config.get(pName);
        return result != null ? result : pDefault;
    }
}

