/*
 * Decompiled with CFR 0.152.
 */
package play.modules.vhost;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import net.contentobjects.jnotify.JNotify;
import net.contentobjects.jnotify.JNotifyListener;
import play.Logger;
import play.Play;
import play.PlayPlugin;
import play.libs.MimeTypes;
import play.modules.vhost.VirtualHost;
import play.modules.vhost.VirtualHostListener;
import play.mvc.Http;
import play.mvc.results.NotFound;
import play.templates.BaseTemplate;
import play.templates.GroovyTemplateCompiler;
import play.templates.Template;
import play.utils.Properties;
import play.vfs.VirtualFile;

public class VirtualHostsPlugin
extends PlayPlugin {
    private static VirtualHostsPlugin config = null;
    private String configDir = null;
    private Integer notificationWatch;
    private JNotifyListener notificationListener = null;
    private Map<String, VirtualHost> vHostMap = new HashMap<String, VirtualHost>();
    private Map<String, VirtualHost> fqdnMap = new HashMap<String, VirtualHost>();

    public static boolean isEnabled() {
        return config != null;
    }

    public VirtualHostsPlugin() {
        if (config == null) {
            config = this;
        }
    }

    public VirtualHostsPlugin(String pConfigDir) {
        if (config == null) {
            config = this;
        }
        config.loadVirtualHostRegistrations(pConfigDir);
    }

    public void onApplicationStart() {
        String cfgDir = Play.configuration.getProperty("virtualhosts.dir", Play.getFile((String)"conf").getAbsolutePath());
        config.loadVirtualHostRegistrations(cfgDir);
        if (this.notificationListener == null) {
            this.notificationListener = new JNotifyListener(){

                public void fileCreated(int wd, String rootPath, String name) {
                    File f = this.getVirtualHostFile(rootPath, name);
                    if (f != null) {
                        Logger.info((String)"Registering new virtual host from '%s'", (Object[])new Object[]{f.getAbsolutePath()});
                        config.registerVirtualHost(f);
                    }
                }

                public void fileDeleted(int wd, String rootPath, String name) {
                    File f = this.getVirtualHostFile(rootPath, name);
                    if (f != null) {
                        Logger.info((String)"Unregistering the virtual host from '%s'", (Object[])new Object[]{f.getAbsolutePath()});
                        config.unregisterVirtualHost(f);
                    }
                }

                public void fileModified(int wd, String rootPath, String name) {
                    File f = this.getVirtualHostFile(rootPath, name);
                    if (f != null) {
                        Logger.info((String)"Updating virtual host registration from '%s'", (Object[])new Object[]{f.getAbsolutePath()});
                        config.registerVirtualHost(f);
                    }
                }

                public void fileRenamed(int wd, String rootPath, String oldName, String newName) {
                    this.fileDeleted(wd, rootPath, oldName);
                    this.fileCreated(wd, rootPath, newName);
                }

                private File getVirtualHostFile(String dir, String nameName) {
                    File f = new File(dir, nameName);
                    return f.getName().endsWith(".vhost") ? f : null;
                }
            };
        }
        try {
            this.notificationWatch = JNotify.addWatch((String)VirtualHostsPlugin.config.configDir, (int)15, (boolean)false, (JNotifyListener)this.notificationListener);
            Logger.info((String)"Monitoring  '%s' for virtual host registrations", (Object[])new Object[]{VirtualHostsPlugin.config.configDir});
        }
        catch (Throwable t) {
            Logger.error((String)t.getMessage(), (Object[])new Object[0]);
            Logger.warn((String)"Cannot initialize filesystem notification listener. You have to restart application if changes to virtual host registrations are made.", (Object[])new Object[0]);
        }
    }

    public void onApplicationStop() {
        if (this.notificationWatch != null) {
            try {
                JNotify.removeWatch((int)this.notificationWatch);
                this.notificationWatch = null;
                Logger.info((String)"VirtualHost registration monitor has been stopped", (Object[])new Object[0]);
            }
            catch (Throwable t) {
                Logger.error((String)t.getMessage(), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Template loadTemplate(VirtualFile file) {
        Http.Request currentRequest = Http.Request.current();
        if (currentRequest == null || currentRequest.domain == null) {
            return null;
        }
        VirtualHost host = VirtualHostsPlugin.findHost(currentRequest.domain);
        if (host == null) {
            return null;
        }
        String filename = this.relativeFilename(file);
        VirtualFile vfile = this.findReplacement(filename, host);
        if (vfile == null || !vfile.exists()) {
            return null;
        }
        BaseTemplate result = null;
        Map<String, BaseTemplate> map = host.templateCache;
        synchronized (map) {
            result = host.templateCache.get(filename);
            if (result == null || Play.mode == Play.Mode.DEV && result.timestamp < vfile.lastModified()) {
                Logger.debug((String)"VHOST: Override template '%s' with '%s'", (Object[])new Object[]{filename, vfile.getRealFile().getAbsolutePath()});
                result = new GroovyTemplateCompiler().compile(vfile);
                host.templateCache.put(filename, result);
            }
        }
        return result;
    }

    public boolean serveStatic(VirtualFile file, Http.Request request, Http.Response response) {
        VirtualHost host = VirtualHostsPlugin.findHost(request.domain);
        if (host == null) {
            return false;
        }
        VirtualFile vfile = this.findReplacement(this.relativeFilename(file), host);
        if (vfile == null || !vfile.exists()) {
            return false;
        }
        Logger.debug((String)"VHOST: Replaced file '%s' with '%s'", (Object[])new Object[]{this.relativeFilename(file), vfile.getRealFile().getAbsolutePath()});
        response.contentType = MimeTypes.getContentType((String)vfile.getName());
        response.status = 200;
        response.direct = vfile.getRealFile();
        return true;
    }

    private String relativeFilename(VirtualFile file) {
        String result = file.relativePath();
        if (result.startsWith("{")) {
            result = result.substring(result.indexOf(125) + 1);
        }
        return result;
    }

    private VirtualFile findReplacement(String file, VirtualHost host) {
        String home = host.config("homedir", null);
        if (home == null) {
            return null;
        }
        if (!home.startsWith("/")) {
            home = Play.applicationPath + "/" + home;
        }
        return VirtualFile.open((String)home).child(file);
    }

    public void beforeInvocation() {
        if (!VirtualHostsPlugin.isEnabled()) {
            return;
        }
        Http.Request currentRequest = Http.Request.current();
        if (currentRequest == null || currentRequest.domain == null) {
            return;
        }
        VirtualHost host = VirtualHostsPlugin.findHost(currentRequest.domain);
        if (host == null) {
            if (!currentRequest.domain.equals("localhost")) {
                throw new NotFound("");
            }
            return;
        }
        currentRequest.args.putAll(host.config);
        HashMap<String, DataSource> dataSources = new HashMap<String, DataSource>();
        if (host.getDataSource() != null) {
            dataSources.put(host.getName(), host.getDataSource());
        }
        currentRequest.args.put("dataSources", dataSources);
    }

    static VirtualHost findHost(String domain) {
        return config != null ? VirtualHostsPlugin.config.fqdnMap.get(domain) : null;
    }

    static VirtualHost[] getAllHosts() {
        VirtualHost[] empty = new VirtualHost[]{};
        return config != null ? VirtualHostsPlugin.config.fqdnMap.values().toArray(empty) : empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadVirtualHostRegistrations(String pConfigDir) {
        VirtualHostsPlugin virtualHostsPlugin = this;
        synchronized (virtualHostsPlugin) {
            this.vHostMap.clear();
            this.fqdnMap.clear();
        }
        this.configDir = pConfigDir;
        File cfgDir = new File(this.configDir);
        File[] cfgFiles = cfgDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".vhost") && file.isFile();
            }
        });
        if (cfgFiles == null) {
            return;
        }
        for (int i = 0; i < cfgFiles.length; ++i) {
            Logger.info((String)"Registering new virtual host from '%s'", (Object[])new Object[]{cfgFiles[i].getAbsolutePath()});
            this.registerVirtualHost(cfgFiles[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerVirtualHost(File pVHostFile) {
        VirtualHost host;
        Properties vHostConfig = new Properties();
        String vHostFilename = pVHostFile.getAbsolutePath();
        boolean fileExists = pVHostFile.exists();
        try {
            if (fileExists) {
                vHostConfig.load((InputStream)new FileInputStream(pVHostFile));
            }
        }
        catch (FileNotFoundException e) {
            Logger.error((String)"File '%s' vanished. Registration processing is cancelled.", (Object[])new Object[]{vHostFilename});
            return;
        }
        catch (IOException e) {
            Logger.info((String)"Unexpected error occured while procesing virtual host registration from '%s'. Error message was: %s", (Object[])new Object[]{pVHostFile.getName(), e.getMessage()});
            return;
        }
        this.unregisterVirtualHost(vHostFilename);
        if (vHostConfig.size() == 0) {
            return;
        }
        ArrayList<String> fqdnList = new ArrayList<String>();
        String[] fqdns = vHostConfig.get("fqdns", "").split(",");
        if (fqdns.length == 0) {
            Logger.error((String)"No fqdns set for this virtual host. Ignoring registration file '%s'", (Object[])new Object[]{vHostFilename});
            return;
        }
        for (String fqdn : fqdns) {
            if (this.fqdnMap.containsKey(fqdn)) {
                Logger.warn((String)"'%s' is already in use by another virtual host. FQDN registration skipped.", (Object[])new Object[]{fqdn});
                continue;
            }
            fqdnList.add(fqdn);
        }
        if (fqdnList.size() == 0) {
            Logger.error((String)"All fqdns for this virtual host are aleady registered. Ignoring registration file '%s'", (Object[])new Object[]{vHostFilename});
            return;
        }
        String driver = (String)vHostConfig.get((Object)"db.driver");
        try {
            if (driver != null) {
                Class.forName(driver);
            }
        }
        catch (ClassNotFoundException e) {
            Logger.error((String)"Database driver not found(%s). Virtual host in '%s' not loaded", (Object[])new Object[]{driver, vHostFilename});
            return;
        }
        String dbUrl = vHostConfig.get("db.url", null);
        if (dbUrl == null) {
            host = new VirtualHost(fqdnList, (Map<String, String>)vHostConfig, null);
        } else {
            System.setProperty("com.mchange.v2.log.MLog", "com.mchange.v2.log.FallbackMLog");
            System.setProperty("com.mchange.v2.log.FallbackMLog.DEFAULT_CUTOFF_LEVEL", "OFF");
            ComboPooledDataSource cpds = new ComboPooledDataSource();
            cpds.setJdbcUrl("jdbc:" + dbUrl);
            cpds.setUser(vHostConfig.get("db.user", ""));
            cpds.setPassword(vHostConfig.get("db.pass", ""));
            cpds.setCheckoutTimeout(Integer.parseInt(vHostConfig.get("db.pool.timeout", "5000")));
            cpds.setMaxPoolSize(Integer.parseInt(vHostConfig.get("db.pool.maxSize", "5")));
            cpds.setMinPoolSize(Integer.parseInt(vHostConfig.get("db.pool.minSize", "1")));
            cpds.setAutoCommitOnClose(true);
            cpds.setAcquireRetryAttempts(1);
            cpds.setAcquireRetryDelay(0);
            host = new VirtualHost(fqdnList, (Map<String, String>)vHostConfig, (DataSource)cpds);
        }
        VirtualHostsPlugin virtualHostsPlugin = this;
        synchronized (virtualHostsPlugin) {
            this.vHostMap.put(vHostFilename, host);
            for (String fqdn : host.getFqdns()) {
                this.fqdnMap.put(fqdn, host);
            }
        }
    }

    private void unregisterVirtualHost(File pVHostFile) {
        String vHostFilename = pVHostFile.getAbsolutePath();
        this.unregisterVirtualHost(vHostFilename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unregisterVirtualHost(String pVHostFilename) {
        VirtualHost vHost = this.vHostMap.get(pVHostFilename);
        if (vHost != null) {
            VirtualHostsPlugin virtualHostsPlugin = this;
            synchronized (virtualHostsPlugin) {
                for (String fqdn : vHost.getFqdns()) {
                    this.fqdnMap.remove(fqdn);
                }
                this.vHostMap.remove(pVHostFilename);
            }
            for (VirtualHostListener vhl : vHost.listeners) {
                vhl.virtualHostUnloaded(vHost);
            }
        }
    }
}

