/*
 * Decompiled with CFR 0.152.
 */
package com.den_4.inotify_java;

import com.den_4.inotify_java.EventQueueFull;
import com.den_4.inotify_java.InotifyEvent;
import com.den_4.inotify_java.InotifyEventListener;
import com.den_4.inotify_java.InsufficientKernelMemoryException;
import com.den_4.inotify_java.SystemLimitException;
import com.den_4.inotify_java.UserLimitException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public final class Inotify {
    private int fileDescriptor;
    private BlockingQueue<InotifyEvent> eventQueue;
    private Thread readerThread;
    private Thread queueThread;
    private List<InotifyEventListener> listeners;
    private boolean destroyed;

    public Inotify() throws UserLimitException, SystemLimitException, InsufficientKernelMemoryException, UnsatisfiedLinkError {
        System.loadLibrary("inotify-java");
        this.fileDescriptor = this.init();
        this.eventQueue = new LinkedBlockingQueue<InotifyEvent>();
        this.listeners = new ArrayList<InotifyEventListener>();
        this.readerThread = new Thread((Runnable)new ReaderThread(), "inotify-java ReaderThread");
        this.readerThread.setDaemon(true);
        this.readerThread.start();
        this.queueThread = new Thread((Runnable)new QueueThread(), "inotify-java QueueThread");
        this.queueThread.start();
    }

    public Inotify(int capacity) throws UserLimitException, SystemLimitException, InsufficientKernelMemoryException, UnsatisfiedLinkError {
        System.loadLibrary("inotify-java");
        this.fileDescriptor = this.init();
        this.eventQueue = new LinkedBlockingQueue<InotifyEvent>(capacity);
        this.listeners = new ArrayList<InotifyEventListener>();
        this.readerThread = new Thread((Runnable)new ReaderThread(), "inotify-java ReaderThread");
        this.readerThread.setDaemon(true);
        this.readerThread.start();
        this.queueThread = new Thread((Runnable)new QueueThread(), "inotify-java QueueThread");
        this.queueThread.start();
    }

    public void destroy() {
        this.destroyed = true;
        this.queueThread.interrupt();
    }

    public void addInotifyEventListener(InotifyEventListener i) {
        this.listeners.add(i);
    }

    public void removeInotifyEventListener(InotifyEventListener i) {
        this.listeners.remove(i);
    }

    public final int getFileDescriptor() {
        return this.fileDescriptor;
    }

    private native int init();

    public int addWatch(String path, int constantMask) {
        if (path == null) {
            throw new IllegalArgumentException("path cannot be null");
        }
        return this.add_watch(this.fileDescriptor, path, constantMask);
    }

    private native int add_watch(int var1, String var2, int var3);

    public boolean removeWatch(int watchDescriptor) {
        return this.rm_watch(this.fileDescriptor, watchDescriptor) == 0;
    }

    private native int rm_watch(int var1, int var2);

    private native void read(int var1);

    private void processEvent(InotifyEvent e) {
        if (!this.eventQueue.offer(e)) {
            for (InotifyEventListener i : this.listeners) {
                i.queueFull(new EventQueueFull(this.fileDescriptor));
            }
        }
    }

    private class QueueThread
    implements Runnable {
        private QueueThread() {
        }

        public void run() {
            while (!Inotify.this.destroyed) {
                try {
                    InotifyEvent e = (InotifyEvent)Inotify.this.eventQueue.take();
                    for (InotifyEventListener i : Inotify.this.listeners) {
                        i.filesystemEventOccurred(e);
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    private class ReaderThread
    implements Runnable {
        private ReaderThread() {
        }

        public void run() {
            while (!Inotify.this.destroyed) {
                Inotify.this.read(Inotify.this.fileDescriptor);
            }
        }
    }
}

