/*
 * Decompiled with CFR 0.152.
 */
package play.modules.webdrive;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.android.AndroidDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.iphone.IPhoneDriver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverManager {
    private static final Map<String, Class<? extends WebDriver>> simpleDriverNames = new HashMap<String, Class<? extends WebDriver>>();

    public List<Class<?>> getDriverClasses() {
        ArrayList drivers = new ArrayList();
        String driversProp = System.getProperty("webdrive.classes");
        if (driversProp == null || driversProp.trim().isEmpty()) {
            return drivers;
        }
        for (String driver : driversProp.split(",")) {
            Class<Object> clazz;
            try {
                clazz = Class.forName(driver);
            }
            catch (ClassNotFoundException e) {
                clazz = simpleDriverNames.get(driver);
            }
            if (clazz == null || !WebDriver.class.isAssignableFrom(clazz)) {
                System.out.println("~ " + driver + " is not a valid WebDriver implementation.");
                continue;
            }
            if (InternetExplorerDriver.class.equals(clazz) && !System.getProperty("os.name").startsWith("Windows")) {
                System.out.println("~ Cannot test with IE on " + System.getProperty("os.name"));
                continue;
            }
            drivers.add(clazz);
        }
        return drivers;
    }

    static {
        simpleDriverNames.put("htmlunit", HtmlUnitDriver.class);
        simpleDriverNames.put("android", AndroidDriver.class);
        simpleDriverNames.put("chrome", ChromeDriver.class);
        simpleDriverNames.put("firefox", FirefoxDriver.class);
        simpleDriverNames.put("ie", InternetExplorerDriver.class);
        simpleDriverNames.put("iphone", IPhoneDriver.class);
    }
}

