/*
 * Decompiled with CFR 0.152.
 */
package play.modules.webdrive;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import play.modules.webdrive.DriverManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebDriverRunner {
    private static final String DEFAULT_APP_URL = "http://localhost:9000";
    private static final String DEFAULT_TEST_TIMEOUT = "120";
    private File testResultRoot;
    private boolean failed;
    private String appUrlBase;
    private int testTimeoutInSeconds;
    private String seleniumUrlPart;
    private List<String> seleniumTests = new ArrayList<String>();
    private List<String> nonSeleniumTests = new ArrayList<String>();
    private int maxTestNameLength;

    public static void main(String[] args) throws Exception {
        if (new WebDriverRunner().run()) {
            System.exit(0);
        } else {
            System.exit(1);
        }
    }

    public WebDriverRunner() {
        this.appUrlBase = System.getProperty("application.url", DEFAULT_APP_URL);
        String timeoutStr = System.getProperty("webdrive.timeout", DEFAULT_TEST_TIMEOUT);
        try {
            if (timeoutStr == null || timeoutStr.trim().equals("")) {
                timeoutStr = DEFAULT_TEST_TIMEOUT;
            }
            this.testTimeoutInSeconds = Integer.parseInt(timeoutStr);
            System.out.println("~ Using a timeout value of " + this.testTimeoutInSeconds + " seconds");
        }
        catch (NumberFormatException e) {
            System.out.println("~ The timeout value " + timeoutStr + " is not a " + "number. Setting to default value " + DEFAULT_TEST_TIMEOUT + " seconds");
            this.testTimeoutInSeconds = Integer.parseInt(DEFAULT_TEST_TIMEOUT);
        }
        this.retrieveTestsList();
    }

    private void retrieveTestsList() {
        try {
            String line;
            BufferedReader in = new BufferedReader(new InputStreamReader(new URL(this.appUrlBase + "/@tests.list").openStream(), "utf-8"));
            String marker = in.readLine();
            if (!marker.equals("---")) {
                throw new RuntimeException("Error retrieving list of tests");
            }
            this.testResultRoot = new File(in.readLine());
            this.seleniumUrlPart = in.readLine();
            while ((line = in.readLine()) != null) {
                String test = line;
                String testName = test.replace(".class", "").replace(".test.html", "").replace(".", "/").replace("$", "/");
                if (testName.length() > this.maxTestNameLength) {
                    this.maxTestNameLength = testName.length();
                }
                if (test.contains(".test.html")) {
                    this.seleniumTests.add(test);
                    continue;
                }
                this.nonSeleniumTests.add(test);
            }
            in.close();
            System.out.println("~ " + this.seleniumTests.size() + " selenium test" + (this.seleniumTests.size() != 1 ? "s" : "") + " to run:");
            System.out.println("~ " + this.nonSeleniumTests.size() + " other test" + (this.nonSeleniumTests.size() != 1 ? "s" : "") + " to run:");
            System.out.println("~");
        }
        catch (Exception e) {
            System.out.println("~ The application does not start. There are errors: " + e);
            System.exit(-1);
        }
    }

    private boolean run() throws Exception {
        DriverManager manager = new DriverManager();
        List<Class<?>> driverClasses = manager.getDriverClasses();
        this.runTestsWithDriver(HtmlUnitDriver.class, this.nonSeleniumTests);
        for (Class<?> driverClass : driverClasses) {
            this.runTestsWithDriver(driverClass, this.seleniumTests);
        }
        File resultFile = new File(this.testResultRoot, "result." + (this.failed ? "failed" : "passed"));
        resultFile.createNewFile();
        return !this.failed;
    }

    private void runTestsWithDriver(Class<?> webDriverClass, List<String> tests) throws Exception {
        System.out.println("~ Starting tests with " + webDriverClass);
        WebDriver webDriver = (WebDriver)webDriverClass.newInstance();
        webDriver.get(this.appUrlBase + "/@tests/init");
        boolean ok = true;
        for (String test : tests) {
            long start = System.currentTimeMillis();
            String testName = test.replace(".class", "").replace(".test.html", "").replace(".", "/").replace("$", "/");
            System.out.print("~ " + testName + "... ");
            for (int i = 0; i < this.maxTestNameLength - testName.length(); ++i) {
                System.out.print(" ");
            }
            System.out.print("    ");
            String url = test.endsWith(".class") ? this.appUrlBase + "/@tests/" + test : this.appUrlBase + this.seleniumUrlPart + "?baseUrl=" + this.appUrlBase + "&test=/@tests/" + test + ".suite&auto=true&resultsUrl=/@tests/" + test;
            webDriver.get(url);
            int retry = 0;
            while (retry < this.testTimeoutInSeconds) {
                if (new File(this.testResultRoot, test.replace("/", ".") + ".passed.html").exists()) {
                    System.out.print("PASSED      ");
                    break;
                }
                if (new File(this.testResultRoot, test.replace("/", ".") + ".failed.html").exists()) {
                    System.out.print("FAILED   !  ");
                    ok = false;
                    break;
                }
                if (++retry == this.testTimeoutInSeconds) {
                    System.out.print("TIMEOUT  ?  ");
                    ok = false;
                    break;
                }
                Thread.sleep(1000L);
            }
            int duration = (int)(System.currentTimeMillis() - start);
            int seconds = duration / 1000 % 60;
            int minutes = duration / 60000 % 60;
            if (minutes > 0) {
                System.out.println(minutes + " min " + seconds + "s");
                continue;
            }
            System.out.println(seconds + "s");
        }
        webDriver.get(this.appUrlBase + "/@tests/end?result=" + (ok ? "passed" : "failed"));
        webDriver.quit();
        this.saveTestResults(webDriver.getClass().getSimpleName());
        if (!ok) {
            this.failed = true;
        }
    }

    private void saveTestResults(String webDriverName) {
        File destDir = new File(this.testResultRoot, webDriverName);
        destDir.mkdir();
        for (File file : this.testResultRoot.listFiles()) {
            File newFile;
            String fileName = file.getName();
            if ("application.log".equals(fileName) || !file.isFile() || file.renameTo(newFile = new File(destDir, fileName))) continue;
            System.out.println("~ Could not create " + newFile);
        }
    }
}

